﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

namespace nnt {
namespace usb {

class Button : public glv::Button
{
public:
    struct Style {
        float          textSize;
        glv::Color     textColor;
        glv::Color     backColor;
        glv::Color     borderColor;
        glv::Place::t  captionAlignment;

        Style Inverse() const
        {
            Style style = {
                textSize,
                textColor.inverse(),
                backColor.inverse(),
                borderColor.inverse(),
                captionAlignment,
            };

            return style;
        }
    };

    enum class State {
        On,
        Off,
    };

protected:
    glv::Group            m_Frame;
    glv::Label            m_Label;
    State                 m_State;

private:
    Style                 m_StyleOn;
    Style                 m_StyleOff;

public:
    Button(const glv::Rect& rect,
           const std::string& caption,
           bool  momentary,
           const Style& styleOn,
           const Style& styleOff);

    virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_OVERRIDE;

    State GetState() const;
    void  SetState(State state);
    void  ToggleState();

    void StyleOn (const Style& style);
    void StyleOff(const Style& style);

    virtual const char *className() const NN_OVERRIDE { return "Button"; };

protected:
    virtual void OnClicked();

private:
    void ApplyStyle(const Style& style);
    void UpdateStyle();
};

} // ~usb
} // ~nnt
