﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "widgets/Scene.h"
#include "widgets/RadioGroup.h"

namespace nnt {
namespace usb {

class TuningView : public Scene
{
    NN_DISALLOW_COPY( TuningView );
    NN_DISALLOW_MOVE( TuningView );

public:
    explicit TuningView(Stage& stage) NN_NOEXCEPT;

    ~TuningView() NN_NOEXCEPT;

    virtual const char *className() const { return "TuningView"; };

protected:
    virtual glv::View* firstFocusView() { return m_pDriveStrengthOffset->child; };

private:
    glv::Table   m_Table;
    RadioGroup*  m_pTestMode;
    RadioGroup*  m_pDriveStrengthOffset;
};

} // ~usb
} // ~nnt
