﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "UsbDiag_Theme.h"
#include "UsbDiag_SettingsView.h"
#include "UsbDiag_UsbModel.h"

#include "widgets/CheckBox.h"

#define ENABLE

namespace nnt {
namespace usb {

SettingsView::SettingsView(Stage& stage) NN_NOEXCEPT
    : Scene(stage, "Settings")
    , m_Placer(*this, glv::Direction::S, glv::Place::TL, 50, 30, 20)
{
    disable(glv::Property::DrawBack   |
            glv::Property::Animate);

    m_Placer << new CheckBox(
        "Poll Cradle for FW version",
        g_Model.IsPollingCradle(),
        [](bool checked)->void {
            g_Model.ToggleCradlePolling(checked);
        }
    );

    m_Placer << new CheckBox(
        "Enable dummy device",
        false,
        [](bool checked)->void {
            g_Model.ToggleDummyDevice(checked);
        }
    );

    m_Placer << new CheckBox(
        "Show generic logs",
        g_Model.IsLogEnabled(nn::usb::LogModule_Generic),
        [](bool checked)->void {
            g_Model.ToggleLogEnabled(nn::usb::LogModule_Generic, checked);
        }
    );

    m_Placer << new CheckBox(
        "Show XHCI specific logs",
        g_Model.IsLogEnabled(nn::usb::LogModule_HsXhci),
        [](bool checked)->void {
            g_Model.ToggleLogEnabled(nn::usb::LogModule_HsXhci, checked);
        }
    );

    m_Placer << new CheckBox(
        "Show hub state machine logs",
        g_Model.IsLogEnabled(nn::usb::LogModule_HsFsmHub),
        [](bool checked)->void {
            g_Model.ToggleLogEnabled(nn::usb::LogModule_HsFsmHub, checked);
        }
    );

    m_Placer << new CheckBox(
        "Show device model state machine logs",
        g_Model.IsLogEnabled(nn::usb::LogModule_HsFsmDevice),
        [](bool checked)->void {
            g_Model.ToggleLogEnabled(nn::usb::LogModule_HsFsmDevice, checked);
        }
    );

    m_Placer << new CheckBox(
        "Show device manager state machine logs",
        g_Model.IsLogEnabled(nn::usb::LogModule_HsFsmDeviceManager),
        [](bool checked)->void {
            g_Model.ToggleLogEnabled(nn::usb::LogModule_HsFsmDeviceManager, checked);
        }
    );

    m_Placer << new CheckBox(
        "Show control transfer state machine logs",
        g_Model.IsLogEnabled(nn::usb::LogModule_HsFsmCtrlXfer),
        [](bool checked)->void {
            g_Model.ToggleLogEnabled(nn::usb::LogModule_HsFsmCtrlXfer, checked);
        }
    );
}

SettingsView::~SettingsView() NN_NOEXCEPT
{
    // nothing special
}

} // ~usb
} // ~nnt
