﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "UsbDiag_Theme.h"
#include "UsbDiag_MenuView.h"
#include "UsbDiag_FooterView.h"
#include "UsbDiag_HomeView.h"
#include "UsbDiag_SettingsView.h"
#include "UsbDiag_TuningView.h"

#include "widgets/Stage.h"

namespace nnt {
namespace usb {

class RootView : public glv::View
{
public:
    explicit RootView(const glv::Rect& rect) NN_NOEXCEPT;

    ~RootView() NN_NOEXCEPT;

    void Start() NN_NOEXCEPT;

    virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT;

    virtual const char *className() const { return "RootView"; };

private:
    Stage           m_Stage;
    FooterView      m_Footer;
    MenuView        m_Menu;

    TuningView      m_Tuning;
    HomeView        m_Home;
    SettingsView    m_Settings;
};

} // ~usb
} // ~nnt
