﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/os/os_UserExceptionHandler.h>
#include <nnt/nntest.h>

#include <nn/usb/pd/usb_PdManufacture.h>
#include <nn/usb/pd/usb_PdCradle.h>

TEST( UsbPdManufacture, Manufacture )
{
    NN_SDK_LOG("[testUsbPd_Manufacture] Main\n");

    nn::Result result;

    nn::usb::pd::Initialize();
    nn::usb::pd::InitializeCradle();
    nn::usb::pd::InitializeManufacture();
    nn::usb::pd::Session session;
    nn::usb::pd::OpenSession( &session );
    nn::usb::pd::CradleSession cradleSession;
    nn::usb::pd::OpenCradleSession( &cradleSession );
    nn::usb::pd::ManufactureSession manufactureSession;
    nn::usb::pd::OpenManufactureSession( &manufactureSession );

    uint16_t tmp;
    nn::usb::pd::GetHostPdcFirmwareType( &tmp, &manufactureSession );
    NN_SDK_LOG("[usb::pd] FirmwareType = %04x\n", tmp);
    nn::usb::pd::GetHostPdcFirmwareRevision( &tmp, &manufactureSession );
    NN_SDK_LOG("[usb::pd] FirmwareRevision = %04x\n", tmp);
    nn::usb::pd::GetHostPdcManufactureId( &tmp, &manufactureSession );
    NN_SDK_LOG("[usb::pd] ManufactureID = %04x\n", tmp);
    nn::usb::pd::GetHostPdcDeviceId( &tmp, &manufactureSession );
    NN_SDK_LOG("[usb::pd] DeviceID = %04x\n", tmp);

    nn::usb::pd::CloseManufactureSession( &manufactureSession );
    nn::usb::pd::CloseCradleSession( &cradleSession );
    nn::usb::pd::CloseSession( &session );
    nn::usb::pd::FinalizeManufacture();
    nn::usb::pd::FinalizeCradle();
    nn::usb::pd::Finalize();
}

