﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/os/os_UserExceptionHandler.h>
#include <nnt/nntest.h>

#include <nn/usb/pd/usb_Pd.h>

//#define ENABLE_WAIT_EVENT

namespace {
    const int RepeatNum = 5;
    const nn::TimeSpan NoticeWaitTimeoutSpan = nn::TimeSpan::FromMilliSeconds( 1000 );
}

TEST( UsbPdBasic, GetStatus )
{
    NN_SDK_LOG("[testUsbPd_Basic] Main\n");

    nn::Result result;

    nn::usb::pd::Initialize();
    nn::usb::pd::Initialize();
    nn::usb::pd::Session session;
    nn::usb::pd::Session session2;
    nn::usb::pd::OpenSession( &session );
    nn::usb::pd::OpenSession( &session2 );
    nn::os::SystemEvent noticeEvent(nn::os::EventClearMode_AutoClear, true);
    nn::os::SystemEvent noticeEvent2(nn::os::EventClearMode_AutoClear, true);
    nn::usb::pd::BindNoticeEvent( noticeEvent.GetBase(), &session );
    nn::usb::pd::BindNoticeEvent( noticeEvent2.GetBase(), &session2 );
    for ( int i = 0; i < RepeatNum; i++ )
    {
        nn::usb::pd::Status status;
        nn::usb::pd::Status status2;
        nn::util::BitPack32* s = &status.m_Data;
        nn::util::BitPack32* s2 = &status2.m_Data;
        NN_UNUSED(s);
        NN_UNUSED(s2);
        nn::usb::pd::GetStatus( &status, &session );
        NN_SDK_LOG("[usb::pd|1] Status = %08x, %08x, %08x, %08x, %08x\n", s[0], s[1], s[2], s[3], s[4]);
        nn::usb::pd::GetStatus( &status2, &session2 );
        NN_SDK_LOG("[usb::pd|2] Status = %08x, %08x, %08x, %08x, %08x\n", s2[0], s2[1], s2[2], s2[3], s2[4]);
        nn::usb::pd::Notice notice;
        nn::usb::pd::Notice notice2;
#ifdef ENABLE_WAIT_EVENT
        noticeEvent.Wait();
#else
        noticeEvent.TimedWait( NoticeWaitTimeoutSpan );
#endif
        noticeEvent.Clear();
        nn::usb::pd::GetNotice( &notice, &session );
        NN_SDK_LOG("[usb::pd|1] Notice = %04x\n", notice.storage);
        nn::usb::pd::GetNotice( &notice, &session );
        NN_SDK_LOG("[usb::pd|1] Notice = %04x\n", notice.storage);
#ifdef ENABLE_WAIT_EVENT
        noticeEvent2.Wait();
#else
        noticeEvent2.TimedWait( NoticeWaitTimeoutSpan );
#endif
        noticeEvent2.Clear();
        nn::usb::pd::GetNotice( &notice2, &session2 );
        NN_SDK_LOG("[usb::pd|2] Notice = %04x\n", notice2.storage);
        nn::usb::pd::GetNotice( &notice2, &session2 );
        NN_SDK_LOG("[usb::pd|2] Notice = %04x\n", notice2.storage);
    }
    nn::usb::pd::UnbindNoticeEvent( &session2 );
    nn::usb::pd::UnbindNoticeEvent( &session );
    nn::usb::pd::CloseSession( &session2 );
    nn::usb::pd::CloseSession( &session );
    nn::usb::pd::Finalize();
    nn::usb::pd::Finalize();
}

