﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Fx3Methods/Fx3.h"

namespace nnt {
namespace usb {
namespace hs {

const Fx3DeviceMode deviceModes[] =
{
    {FX3_DEVICE_FULL_SPEED, FX3_CTRL_MPS_64, FX3_INTERFACE_CTRL},
    {FX3_DEVICE_HIGH_SPEED, FX3_CTRL_MPS_64, FX3_INTERFACE_CTRL},
    {FX3_DEVICE_SUPER_SPEED, FX3_CTRL_MPS_512, FX3_INTERFACE_CTRL},
};

const int ctrlTestValues[] =
{
    1,
    2,
    3,
    511,
    512,
    513,
    4095,
    4096,
    4097,
    20 * 1024 - 1,
    20 * 1024,
    20 * 1024 + 1,
    32 * 1024 - 1,
    32 * 1024,
    32 * 1024 + 1,
    64 * 1024 - 1
    // 64 * 1024 (ctrl can only do 0xffff)
};

enum
{
    TRANSFER_BUFFER_SIZE        = 64 * 1024,
    CTRL_TEST_VALUES_COUNT      = 16,
};

static NN_ALIGNAS(4096) uint8_t g_Buffer[TRANSFER_BUFFER_SIZE];

static void PerformCtrlShortTest()
{
    Fx3TestDataRarameters fx3TestDataParameters;

    std::memset(&fx3TestDataParameters, 0, sizeof(Fx3TestDataRarameters));

    fx3TestDataParameters.endpointAddress   = FX3_ENDPOINT_CTRL_0_IN;
    fx3TestDataParameters.entries           = CTRL_TEST_VALUES_COUNT;
    fx3TestDataParameters.dataSeed          = 0xffffeeee;

    for (int i = 0; i < CTRL_TEST_VALUES_COUNT; i++)
    {
        fx3TestDataParameters.params[i].requestBytes   = 0xffff;
        fx3TestDataParameters.params[i].transferBytes  = ctrlTestValues[i];
    }

    Fx3TransferData(&fx3TestDataParameters, g_Buffer);
}


class HsFx3CtrlShortTest : public ::testing::TestWithParam<Fx3DeviceMode>{};

INSTANTIATE_TEST_CASE_P(DeviceModes, HsFx3CtrlShortTest, ::testing::ValuesIn(deviceModes));

///////////////////////////////////////////////////////////////////////////////
TEST_P(HsFx3CtrlShortTest, VariousBlockSizes)
{
    ASSERT_TRUE(IsFx3Initialized());

    Fx3DeviceMode           fx3DeviceMode;

    fx3DeviceMode.connectSpeed              = GetParam().connectSpeed;
    fx3DeviceMode.interfaceBitmap           = GetParam().interfaceBitmap;

    switch (GetParam().connectSpeed)
    {
        case FX3_DEVICE_FULL_SPEED:
        /*
            FX3_LOG("Not testing for bMaxPacketSize0 < 64\n\r");

            // bMaxPacketSize 8
            FX3_LOG("bMaxPacketSize0 < 64 painfully slow right now, lets only test to 4096.\n\r");
            fx3TestDataParameters.entries           = 8;    // painfully slow right now

            fx3DeviceMode.maxPacketSize             = FX3_CTRL_MPS_8;

            Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);

            Fx3TransferData(&fx3TestDataParameters, g_Buffer);

            // bMaxPacketSize 16
            FX3_LOG("bMaxPacketSize0 < 64 painfully slow right now, lets only test to 4096.\n\r");
            fx3TestDataParameters.entries           = 8;    // painfully slow right now

            fx3DeviceMode.maxPacketSize             = FX3_CTRL_MPS_16;

            Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);

            Fx3TransferData(&fx3TestDataParameters, g_Buffer);

            // bMaxPacketSize 32
            FX3_LOG("bMaxPacketSize0 < 64 painfully slow right now, lets only test to 4096.\n\r");
            fx3TestDataParameters.entries           = 8;    // painfully slow right now

            fx3DeviceMode.maxPacketSize             = FX3_CTRL_MPS_32;

            Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);

            Fx3TransferData(&fx3TestDataParameters, g_Buffer);
        */

            // bMaxPacketSize 64
            fx3DeviceMode.maxPacketSize             = FX3_CTRL_MPS_64;

            Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);

            PerformCtrlShortTest();
            break;
        default:
            // bMaxPacketSize 64 for FS/HS, 512 fo SS: See deviceModes
            fx3DeviceMode.maxPacketSize             = GetParam().maxPacketSize;

            Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);

            PerformCtrlShortTest();
            break;
    }

}


} // hs
} // usb
} // nnt

