﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

// テストツールのボタン入力を扱います。

namespace nnt { namespace usb { namespace pd { namespace input {

    void Initialize() NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    /*
    * @brief    ボタンの入力を読み取り、内部状態を更新します。
    *           それにより、Is***Pushed() の内容が変化します。
    *           非スレッドセーフです。
    */
    void Update() NN_NOEXCEPT;

    bool IsUpPushed() NN_NOEXCEPT;

    bool IsDownPushed() NN_NOEXCEPT;

    bool IsOkPushed() NN_NOEXCEPT;

    bool IsCancelPushed() NN_NOEXCEPT;
}}}}
