﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Repeat running testUsbPd_State with reset for aging.

    .DESCRIPTION
        Repeat running testUsbPd_State with reset for aging.
#>

param
(
    [Parameter(Mandatory=$true)]
    [string]
    # Hardware state defined in libnnt_usbPdUtil
    [ValidateSet( `
        "NoConnection", `
        "OfficialAcAdaptor", `
        "UnofficialAcAdaptor", `
        "CradleWithOfficialAcAdaptor", `
        "CradleWithHdmiTvOff", `
        "CradleWithHdmiTvOn", `
        "CradleWithPc", `
        "CradleWithUnofficialAcAdaptor", `
        "CradleOverVoltage", `
        "CradleOverVoltageAfterContract", `
        "RelayBoxWithOfficialAcAdaptor", `
        "RelayBoxWithHdmiTvOff", `
        "RelayBoxWithHdmiTvOn", `
        "RelayBoxWithPc", `
        "RelayBoxWithUnofficialAcAdaptor", `
        "Pc", `
        "OverVoltage", `
        "OverVoltageAfterContract")]
    $State,

    [Parameter(Mandatory=$true)]
    [string]
    # Target name
    $Target,

    [int]
    # Time (seconds) to continue repeatin
    $Time = 86400,

    [int]
    # Interval (seconds) of running test with reset
    $Interval = 10,

    [string]
    $BuildType = 'Develop',

    [string]
    $Platform = 'NX-NXFP2-a64'
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}/../../../Integrate/Scripts/Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Integrate/Scripts/Modules/Utility"

$RunOnTarget = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/RunOnTarget.exe"
$PdStateTest  = "$(Get-NintendoSdkRootPath)/Tests/Outputs/$Platform/Tests/testUsbPd_State/$BuildType/testUsbPd_State.nca"

# Test existing files
Test-EnsureExistPath $RunOnTarget
Test-EnsureExistPath $PdStateTest

# テストの成功/失敗を判別するためのログ
$PatternFailure = "FAILED";

# $Time で指定した時間だけ、処理を続ける
$end = [DateTime]::Now.AddSeconds($Time)
while ([DateTime]::Now -lt $end)
{
    Invoke-CriticalCommand "& `"$RunOnTarget`" `"$PdStateTest`" -v --reset --target `"$Target`" --failure-timeout 180 --pattern-failure-exit `"$PatternFailure`" '--' --gtest_filter=UsbPdStateTest.$State"
    Sleep $Interval
}
