﻿
# boot プロセスでの更新確認も含めたテスト
# 手動実行用。通常モード K3-Unsigned 前提
#
# BootConfig を Sub 側にも書き込んでおく必要がある
# Externals/NxSystemImages/QspiBootTools/params-bc.bin を
# 00 00 01 00 00 00 00 00 00 00 80 00 00 04 00 00
# から
# 00 00 01 00 00 00 00 00 00 00 00 01 00 04 00 00
# に変更して Write-ProperBootConfig とか実行するとできる

KEY_TYPE="K5"

RUN_ON_TARGET="$NINTENDO_SDK_ROOT/Tools/CommandLineTools/RunOnTarget.exe"
CONTROL_TARGET="$NINTENDO_SDK_ROOT/Tools/CommandLineTools/ControlTarget.exe"
DEVMENU_COMMAND_SYSTEM="$NINTENDO_SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommandSystem/Develop/DevMenuCommandSystem.nca"
BOOTIMAGE_PACKAGE=`cygpath -awl $NINTENDO_SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/SystemData/BootImagePackage-${KEY_TYPE}-Unsigned/Develop/BootImagePackage-${KEY_TYPE}-Unsigned.nsp`
BOOTIMAGE_PACKAGE_EXFAT=`cygpath -awl $NINTENDO_SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/SystemData/BootImagePackageExFat-${KEY_TYPE}-Unsigned/Develop/BootImagePackageExFat-${KEY_TYPE}-Unsigned.nsp`
BOOTIMAGE_PACKAGE_SAFE=`cygpath -awl $NINTENDO_SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/SystemData/BootImagePackageSafe-${KEY_TYPE}-Unsigned/Develop/BootImagePackageSafe-${KEY_TYPE}-Unsigned.nsp`
BOOTIMAGE_PACKAGE_EXFAT_SAFE=`cygpath -awl $NINTENDO_SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/SystemData/BootImagePackageExFatSafe-${KEY_TYPE}-Unsigned/Develop/BootImagePackageExFatSafe-${KEY_TYPE}-Unsigned.nsp`

HELLO_WORLD="$NINTENDO_SDK_ROOT/Programs/Iris/Outputs/NX-NXFP2-a64/TargetTools/HelloWorld/Develop/HelloWorld.nca"

# BootImagePackage / BootImagePackageSafe のインストール
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram uninstall 0x0100000000000819
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram uninstall 0x010000000000081A
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram uninstall 0x010000000000081B
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram uninstall 0x010000000000081C
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram install $BOOTIMAGE_PACKAGE
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram install $BOOTIMAGE_PACKAGE_SAFE

# とりあえず正しい状態にする
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate update-bootimages
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate update-bootimages-safe
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate mark-verifying-required 0
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate mark-verifying-required-safe 0

# 再起動
$CONTROL_TARGET reset
sleep 10

# ブートイメージパッケージの取得
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-package-id | grep 0100000000000819 || exit -1
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-package-id-safe | grep 010000000000081a || exit -1

# exfat 版のインストール
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram install $BOOTIMAGE_PACKAGE_EXFAT

$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-package-id | grep 010000000000081b || exit -1
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-package-id-safe | grep 010000000000081a || exit -1

# セーフ側 exfat 版のインストール
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram install $BOOTIMAGE_PACKAGE_EXFAT_SAFE

$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-package-id | grep 010000000000081b || exit -1
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-package-id-safe | grep 010000000000081c || exit -1

# 通常側のアンインストール
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemprogram uninstall 0x010000000000081B
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-package-id | grep 0100000000000819 || exit -1
$RUN_ON_TARGET $DEVMENU_COMMAND_SYSTEM -- systemupdate get-bootimage-package-id-safe | grep 010000000000081c || exit -1

