﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class Mix
{

public:

    void Initialize(Input *pInput, uint32_t InputEntries);
    void Finalize();

    uint8_t * GetOutputFrame();

private:

    NN_ALIGNAS(4096) uint8_t    m_Buffer[BuffersCount][4096];
    uint32_t                    m_FrameCounter;
    Input                      *m_pInput;
    uint32_t                    m_InputEntries;
};

