﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Includes.h"

//////////////////////////////////////////////////////////////////////////////
static nn::cduac::Host      g_Host;
static nn::cduac::Parser    g_Parser;
static Input                g_Input[InputsCount];
static Output               g_Output;
static Mix                  g_Mix;
static nn::os::SystemEvent  g_AttachEvent;
static bool                 g_Run;


//////////////////////////////////////////////////////////////////////////////
static bool IsInput(nn::cduac::AudioControlInputTerminal *pInputTerminal, nn::cduac::AudioControlOutputTerminal *pOutputTerminal)
{
    bool ret = false;

    if (pOutputTerminal->wTermainalType == (uint16_t)nn::cduac::UsbTerminalType::UsbTerminalType_Streaming)
    {
        switch (pInputTerminal->wTermainalType)
        {
        case nn::cduac::InputTerminalType::InputTerminalType_Microphone:

            ret = true;

            break;

        default:

            break;
        }
    }

    return ret;
}


//////////////////////////////////////////////////////////////////////////////
static bool IsOutput(nn::cduac::AudioControlInputTerminal *pInputTerminal, nn::cduac::AudioControlOutputTerminal *pOutputTerminal)
{
    bool ret = false;

    if (pInputTerminal->wTermainalType == (uint16_t)nn::cduac::UsbTerminalType::UsbTerminalType_Streaming)
    {
        switch (pOutputTerminal->wTermainalType)
        {
        case nn::cduac::OutputTerminalType::OutputTermainalType_Speaker:
        case nn::cduac::OutputTerminalType::OutputTermainalType_DesktopSpeaker:
        case nn::cduac::OutputTerminalType::OutputTermainalType_RoomSpeaker:
        case nn::cduac::OutputTerminalType::OutputTermainalType_Headphones:

            ret = true;

            break;

        default:

            break;
        }
    }

    return ret;
}


//////////////////////////////////////////////////////////////////////////////
static void AttachLoop()
{
    while (g_Run)
    {
        int32_t ifCount;
        nn::usb::InterfaceQueryOutput interfaceQueryOutput[nn::usb::HsLimitMaxInterfacesPerClientCount];

        g_AttachEvent.Wait();

        g_Host.QueryAvailableInterfaces(&ifCount, interfaceQueryOutput, sizeof(interfaceQueryOutput));

        for (int i = 0; i < ifCount; i++)
        {
            // Audio streamig interface is > 0
            if(interfaceQueryOutput[i].ifProfile.ifDesc.bInterfaceNumber)
            {
                nn::cduac::InterfaceProfile interfaceProfile;

                if (interfaceQueryOutput[i].ifProfile.ifDesc.bInterfaceNumber)
                {
                    g_Parser.CreateInterfaceProfile(&interfaceProfile, &g_Host, &interfaceQueryOutput[i]);

                    nn::cduac::AudioControlInputTerminal *pInputTerminal    = g_Parser.GetInputTerminal(&interfaceProfile);
                    nn::cduac::AudioControlOutputTerminal *pOutputTerminal  = g_Parser.GetOutputTerminal(&interfaceProfile);

                    if (pInputTerminal && pOutputTerminal)
                    {
                        // input
                        for (int i = 0; i < InputsCount; i++)
                        {
                            if ((g_Input[i].IsAttached() == false) && IsInput(pInputTerminal, pOutputTerminal))
                            {
                                NN_SDK_LOG("Input %08x Attaching\n", &g_Input[i]);

                                nn::Result result = g_Input[i].Start(&g_Host, &g_Parser, &interfaceProfile);

                                if (result.IsSuccess())
                                {
                                    NN_SDK_LOG("Input %08x Attached\n\n", &g_Input[i]);
                                    break;
                                }
                            }
                        }

                        // output
                        if ((g_Output.IsAttached() == false) && IsOutput(pInputTerminal, pOutputTerminal))
                        {
                            NN_SDK_LOG("Output %08x Attaching\n", &g_Output);

                            nn::Result result = g_Output.Start(&g_Host, &g_Parser, &g_Mix, &interfaceProfile);

                            if (result.IsSuccess())
                            {
                                NN_SDK_LOG("Output %08x Attached\n\n", &g_Output);
                            }
                        }
                    }
                }
            }
        }
    }
}


//////////////////////////////////////////////////////////////////////////////
extern "C" void nnMain()
{
    NN_SDK_LOG("->%s\n", __FUNCTION__);

    g_Host.Initialize();
    g_Host.CreateInterfaceAvailableEvent(g_AttachEvent.GetBase());

    g_Mix.Initialize(&g_Input[0], InputsCount);

    for (int i = 0; i < InputsCount; i++)
    {
        g_Input[i].Initialize();
    }

    g_Output.Initialize();

    g_Run = true;

    AttachLoop();

    g_Output.Finalize();

    for (int i = 0; i < InputsCount; i++)
    {
        g_Input[i].Finalize();
    }

    g_Mix.Finalize();

    g_Host.DestroyInterfaceAvailableEvent(g_AttachEvent.GetBase());
    g_Host.Finalize();

    NN_SDK_LOG("<-%s\n", __FUNCTION__);
}
