﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/ts.h>

#include "../Common/Ts_SampleCommon.h"

// メイン関数
extern "C" void nnMain()
{
    NN_LOG("/// Ts Read Temp with HIPC ///\n");

    // ライブラリの初期化
    NN_LOG("Initialize()\n");
    ::nn::ts::Initialize();

    NN_LOG("--GetTemperatureRange()--------------------------------\n");
    for(int i = 0; i < NumberOfLocation; i++){
        ::nn::ts::LimitTemperature limit;
        limit = ::nn::ts::GetTemperatureRange(LocationtTable[i].location);
        NN_LOG("%s: %d, %d\n",LocationtTable[i].name , limit.low, limit.high);
    }

    NN_LOG("--GetTemperature()--------------------------------\n");
    for(int i = 0; i < NumberOfLocation; i++){
        NN_LOG("%s: ",LocationtTable[i].name);
        for(int count = 0; count < MeasurementLoopCount; count++)
        {
            int temperature;
            NN_ABORT_UNLESS_RESULT_SUCCESS(::nn::ts::GetTemperature(&temperature, LocationtTable[i].location));
            NN_LOG("%3d,", temperature);
            ::nn::os::SleepThread(::nn::TimeSpan::FromMilliSeconds(MeasurementInterbalMs));
        }
        NN_LOG("\n");
    }

    NN_LOG("--GetTemperatureMilliC()--------------------------------\n");
    for(int i = 0; i < NumberOfLocation; i++){
        NN_LOG("%s: ",LocationtTable[i].name);
        for(int count = 0; count < MeasurementLoopCount; count++)
        {
            int temperatureMilliC;
            NN_ABORT_UNLESS_RESULT_SUCCESS(::nn::ts::GetTemperatureMilliC(&temperatureMilliC, LocationtTable[i].location));
            NN_LOG("%6d,", temperatureMilliC);
            ::nn::os::SleepThread(::nn::TimeSpan::FromMilliSeconds(MeasurementInterbalMs));
        }
        NN_LOG("\n");
    }

    // ライブラリの終了
    NN_LOG("Finalize()\n");
    ::nn::ts::Finalize();
}

