﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using ZarfCreator.VersionData;

namespace ZarfCreatorTest.VersionTest
{
    /// <summary>
    /// スナップショットバージョンのテストクラスです。
    /// </summary>
    [TestClass]
    public class SnapshotVersionTest
    {
        [TestMethod]
        public void TestCreateSnapshotVersion()
        {
            var result = SnapshotVersionDataFactory.CreateSnapshotVersion("1.2.3", "CI2017.6.9", false);
            Assert.AreEqual("1.2.3+CI2017.6.9", result);

            result = SnapshotVersionDataFactory.CreateSnapshotVersion("1.2.3+Build4.5", "CI2017.6.9", false);
            Assert.AreEqual("1.2.3+Build4.5.CI2017.6.9", result);

            result = SnapshotVersionDataFactory.CreateSnapshotVersion("1.2.3", "CI2017.6.9", true);
            Assert.AreEqual("1.2.3-CI2017.6.9", result);

            result = SnapshotVersionDataFactory.CreateSnapshotVersion("1.2.3+Build4.5", "CI2017.6.9", true);
            Assert.AreEqual("1.2.3-CI2017.6.9+Build4.5", result);

            result = SnapshotVersionDataFactory.CreateSnapshotVersion("1.2.3-beta.1+Build4.5", "CI2017.6.9", true);
            Assert.AreEqual("1.2.3-beta.1.CI2017.6.9+Build4.5", result);
        }
    }
}
