﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UartTestHost
{
    /// <summary>
    /// コマンドラインオプションのパーサ
    /// </summary>
    public class CmdlineOption
    {
        public const string UsageString =
@"Usage: UartSerialCommunicationTestHost.exe [options]
    --port-name [PortName]  specify serial port name (e.g. 'COM3')
    -h                      show this help
";

        /// <summary>
        /// オプションで指定されたポート名
        /// </summary>
        public static string PortName { get; private set; }

        /// <summary>
        /// プログラムの起動引数文字列をパースします。
        /// ヘルプ表示オプションが指定された場合など、テスト本体に移らずプログラムを終了すべきときに false を返します。
        /// </summary>
        /// <param name="args">コマンドラインオプション</param>
        /// <returns>プログラムの実行可否</returns>
        public static bool Parse(string[] args)
        {
            for (int i = 0; i < args.Length; i++)
            {
                string arg = args[i];

                if (arg == "--port-name")
                {
                    ++i;
                    PortName = args[i];
                }
                else if (arg == "-h")
                {
                    Usage();
                    return false;
                }
                else
                {
                    Console.WriteLine("Ignored invalid option: " + arg);
                }
            }
            return true;
        }

        public static void Usage()
        {
            Console.WriteLine(CmdlineOption.UsageString);
        }
    }
}
