﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunnerTest.TestStatementInfoTest
{
    using System.Collections.Generic;
    using System.Linq;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using TestRunner;
    using TestRunner.Executer;

    /// <summary>
    /// [TestRunner.TestStatementInfo]::GetListContext用のテスト関数を定義します。
    /// </summary>
    [TestClass]
    public class GetListContextTest
    {
        /// <summary>
        /// 不変条件: テストリストコンテキストの情報は生成元のステートメントの情報に基づく
        /// </summary>
        [TestMethod]
        public void GetListContextInvariantTest001()
        {
            var platformName = "foo";

            var buildTypeName = "hoge";

            var statement = new TestStatementInfo(new Dictionary<string, object>());

            statement = statement.ProduceTestStatementInfosByDocuments(new List<object>()
            {
                new Dictionary<string, object>(),
                new Dictionary<string, object>(),
                new Dictionary<string, object>()
                {
                    { "Platforms", new List<object>() { platformName } },
                    { "BuildTypes", new List<object>() { buildTypeName } },
                }
            }).Last();

            statement = statement.ProduceTestStatementInfosByPlatforms(
                new List<string>() { "Win32", platformName }).Last();

            statement = statement.ProduceTestStatementInfosByBuildTypes(
                new List<string>() { "Debug", "Develop", "Release", buildTypeName }).Last();

            statement.UpdateResultDirectory("bar", 5u, "baz.testlist.yml");

            var listContext = statement.GetListContext(new ListContext()
            {
                ListName = @"qux\quux",
                PlatformName = platformName
            });

            Assert.AreEqual(@"bar\00005_003_02_04_baz\00_000_00_quux.list.result.xml", listContext.Path);
            Assert.AreEqual(3u, listContext.StatementId);
            Assert.AreEqual(2u, listContext.PlatformId);
            Assert.AreEqual(platformName, listContext.PlatformName);
            Assert.AreEqual(4u, listContext.BuildTypeId);
            Assert.AreEqual(buildTypeName, listContext.BuildTypeName);
        }
    }
}
