﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.ServiceFramework;

namespace Nintendo.ServiceFrameworkTest
{
    [TestClass]
    public class ExceptionsTest
    {
        internal interface I
        {
            void MethodF(int parameterA);
        }

        [TestMethod]
        public void TestUnknownEntityException()
        {
            var e = new UnknownEntityException("Sample", typeof(I), string.Empty);
            Assert.IsTrue(e.Message.Contains(@"[Sample]"));
            Assert.IsTrue(e.Message.Contains(typeof(I).ToString()));
        }

        [TestMethod]
        public void TestInvalidInterfaceException()
        {
            var e = new InvalidInterfaceException("Sample", typeof(I), string.Empty);
            Assert.IsTrue(e.Message.Contains(@"[Sample]"));
            Assert.IsTrue(e.Message.Contains(typeof(I).ToString()));
        }

        [TestMethod]
        public void TestInvalidMethodException()
        {
            var m = typeof(I).GetMethod("MethodF");
            var e = new InvalidMethodException("Sample", m, string.Empty);
            Assert.IsTrue(e.Message.Contains(@"[Sample]"));
            Assert.IsTrue(e.Message.Contains(typeof(I).ToString() + ".MethodF"));
        }

        [TestMethod]
        public void TestInvalidMethodParameterException()
        {
            var m = typeof(I).GetMethod("MethodF");
            var p = m.GetParameters()[0];
            var e = new InvalidMethodParameterException("Sample", p, string.Empty);
            Assert.IsTrue(e.Message.Contains(@"[Sample]"));
            Assert.IsTrue(e.Message.Contains(typeof(I).ToString() + ".MethodF"));
            Assert.IsTrue(e.Message.Contains("parameterA"));
        }

        public struct S
        {
            public int FieldMember;
        }

        [TestMethod]
        public void TestInvalidStructException()
        {
            var e = new InvalidStructException("Sample", typeof(S), string.Empty);
            Assert.IsTrue(e.Message.Contains(@"[Sample]"));
            Assert.IsTrue(e.Message.Contains(typeof(S).ToString()));
        }

        [TestMethod]
        public void TestInvalidFieldParameterException()
        {
            var f = typeof(S).GetField("FieldMember");
            var e = new InvalidFieldException("Sample", f, string.Empty);
            Assert.IsTrue(e.Message.Contains(@"[Sample]"));
            Assert.IsTrue(e.Message.Contains(typeof(S).ToString() + ".FieldMember"));
        }
    }
}
