﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Nintendo.ServiceFrameworkTest.CppCode
{
    [TestClass]
    public class BuiltInCppCodeEmitterTest
    {
        [TestMethod]
        public void TestGetCppTypeString()
        {
            foreach (var friendly in new[] { false, true })
            {
                Assert.AreEqual(@"bool", typeof(bool).GetSfEntity().GetCppTypeString(friendly));
                Assert.AreEqual(@"float", typeof(float).GetSfEntity().GetCppTypeString(friendly));
                Assert.AreEqual(@"double", typeof(double).GetSfEntity().GetCppTypeString(friendly));
                Assert.AreEqual(@"int", typeof(int_t).GetSfEntity().GetCppTypeString(friendly));
                Assert.AreEqual(@"unsigned int", typeof(uint_t).GetSfEntity().GetCppTypeString(friendly));
                Assert.AreEqual(@"char", typeof(char_t).GetSfEntity().GetCppTypeString(friendly));
                Assert.AreEqual(@"char16_t", typeof(char16_t).GetSfEntity().GetCppTypeString(friendly));
                Assert.AreEqual(@"char32_t", typeof(char32_t).GetSfEntity().GetCppTypeString(friendly));
            }
            Assert.AreEqual(@"::std::int8_t", typeof(sbyte).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"::std::uint8_t", typeof(byte).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"::std::int32_t", typeof(int).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"::std::uint32_t", typeof(uint).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"::std::int64_t", typeof(long).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"::std::uint64_t", typeof(ulong).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"std::int8_t", typeof(sbyte).GetSfEntity().GetCppTypeString(true));
            Assert.AreEqual(@"std::uint8_t", typeof(byte).GetSfEntity().GetCppTypeString(true));
            Assert.AreEqual(@"std::int32_t", typeof(int).GetSfEntity().GetCppTypeString(true));
            Assert.AreEqual(@"std::uint32_t", typeof(uint).GetSfEntity().GetCppTypeString(true));
            Assert.AreEqual(@"std::int64_t", typeof(long).GetSfEntity().GetCppTypeString(true));
            Assert.AreEqual(@"std::uint64_t", typeof(ulong).GetSfEntity().GetCppTypeString(true));
        }

        [TestMethod]
        public void TestGetParameterString()
        {
            Assert.AreEqual(@"float foo", typeof(float).GetSfEntity().GetParameterString(@"foo", InOutType.In, false));
            Assert.AreEqual(@"float foo", typeof(float).GetSfEntity().GetParameterString(@"foo", InOutType.In, true));
            Assert.AreEqual(@"::nn::sf::Out<float> foo", typeof(float).GetSfEntity().GetParameterString(@"foo", InOutType.Out, false));
            Assert.AreEqual(@"nn::sf::Out<float> foo", typeof(float).GetSfEntity().GetParameterString(@"foo", InOutType.Out, true));
        }

        [TestMethod]
        public void TestGetStructPlacedString()
        {
            Assert.AreEqual(@"float foo", typeof(float).GetSfEntity().GetStructPlacedString(@"foo", false));
            Assert.AreEqual(@"float foo", typeof(float).GetSfEntity().GetStructPlacedString(@"foo", true));
        }

        [TestMethod]
        public void TestGetExternalIncludes()
        {
            AssertionUtility.AssertAreSetEqual(new[] { @"<cstdint>" }, typeof(int).GetSfEntity().GetExternalIncludes());
            AssertionUtility.AssertAreSetEqual(Enumerable.Empty<string>(), typeof(float).GetSfEntity().GetExternalIncludes());
        }

        [TestMethod]
        public void TestGetAdditionalIncludes()
        {
            AssertionUtility.AssertAreSetEqual(Enumerable.Empty<string>(), typeof(int).GetSfEntity().GetAdditionalIncludes());
        }

        [TestMethod]
        public void TestEmitForwardDeclarationCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(int).GetSfEntity().EmitForwardDeclarationCode);
        }

        [TestMethod]
        public void TestEmitDefinitionCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(int).GetSfEntity().EmitDefinitionCode);
        }

        [TestMethod]
        public void TestEmitReferenceCheckCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(int).GetSfEntity().EmitReferenceCheckCode);
        }
    }
}
