﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.ServiceFramework;

namespace Nintendo.ServiceFrameworkTest
{
    [TestClass]
    public class BinaryFormatUtilityTest
    {
        #region TestUnknownEntity

        [TestMethod]
        public void TestSizeAndAlignment()
        {
            {
                var saa = BinaryFormatUtility.GetSizeAndAlignment(new SizeAndAlignment[]
                {
                });
                Assert.AreEqual(0, saa.Size);
                Assert.AreEqual(1, saa.Alignment);
            }
            {
                var saa = BinaryFormatUtility.GetSizeAndAlignment(new[]
                {
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                });
                Assert.AreEqual(1, saa.Size);
                Assert.AreEqual(1, saa.Alignment);
            }
            {
                var saa = BinaryFormatUtility.GetSizeAndAlignment(new[]
                {
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                    new SizeAndAlignment { Size = 2, Alignment = 1 },
                });
                Assert.AreEqual(3, saa.Size);
                Assert.AreEqual(1, saa.Alignment);
            }
            {
                var saa = BinaryFormatUtility.GetSizeAndAlignment(new[]
                {
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                    new SizeAndAlignment { Size = 2, Alignment = 2 },
                });
                Assert.AreEqual(4, saa.Size);
                Assert.AreEqual(2, saa.Alignment);
            }
            {
                var saa = BinaryFormatUtility.GetSizeAndAlignment(new[]
                {
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                    new SizeAndAlignment { Size = 2, Alignment = 2 },
                });
                Assert.AreEqual(4, saa.Size);
                Assert.AreEqual(2, saa.Alignment);
            }
            {
                var saa = BinaryFormatUtility.GetSizeAndAlignment(new[]
                {
                    new SizeAndAlignment { Size = 2, Alignment = 2 },
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                });
                Assert.AreEqual(4, saa.Size);
                Assert.AreEqual(2, saa.Alignment);
            }
            {
                var saa = BinaryFormatUtility.GetSizeAndAlignment(new[]
                {
                    new SizeAndAlignment { Size = 2, Alignment = 2 },
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                });
                Assert.AreEqual(4, saa.Size);
                Assert.AreEqual(2, saa.Alignment);
            }
            {
                var saa = BinaryFormatUtility.GetSizeAndAlignment(new[]
                {
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                    new SizeAndAlignment { Size = 2, Alignment = 2 },
                    new SizeAndAlignment { Size = 1, Alignment = 1 },
                });
                Assert.AreEqual(6, saa.Size);
                Assert.AreEqual(2, saa.Alignment);
            }
        }

        #endregion
    }
}
