﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TestUtility;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace MakeNroTest
{
    public class TestBase
    {
        public const string InvalidBssAddressFile   = "InvalidBssAddress.so";
        public const string InvalidBssAlignFile     = "InvalidBssAlign.so";
        public const string InvalidSectionAlignFile = "InvalidSectionAlign.so";
        public const string InvalidSegmentAlignFile = "InvalidSegmentAlign.so";
        public const string InvalidTextAddressFile  = "InvalidTextAddress.so";

        public TestContext TestContext { get; set; }

        public string GetTestDsoFilePath()
        {
            TestUtility.TestPath testPath = new TestUtility.TestPath(this.TestContext);
            return testPath.GetSigloRoot() + "\\Externals\\TestBinaries\\Tools\\MakeNroTest\\SuccessBinary.so";
        }

        public string GetTestInvalidDsoDirPath()
        {
            TestUtility.TestPath testPath = new TestUtility.TestPath(this.TestContext);
            return testPath.GetSigloRoot() + "\\Externals\\TestBinaries\\Tools\\MakeNroTest\\";
        }

        public string ExecuteProgram(string inputFilePath, FileManager outputFile, string additionalParam = "")
        {
            System.Diagnostics.Process process = new System.Diagnostics.Process();
            TestUtility.TestPath testPath = new TestUtility.TestPath(this.TestContext);

            process.StartInfo.FileName = testPath.GetSigloRoot() + "\\Tools\\CommandLineTools\\MakeNro\\MakeNro.exe";
            process.StartInfo.Arguments = string.Format("{0} {1} {2}", additionalParam, inputFilePath, outputFile.FilePath);
            process.StartInfo.CreateNoWindow = true;
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardError = true;
            process.Start();

            string errorMsg = process.StandardError.ReadToEnd();
            process.WaitForExit();

            Assert.IsTrue(System.IO.File.Exists(inputFilePath));

            return errorMsg;
        }

        public FileManager SuccessExecute(string inputFilePath, string additionalParam = "")
        {
            FileManager outputDesc = new FileManager();
            string err = ExecuteProgram(inputFilePath, outputDesc, additionalParam);
            Assert.IsTrue(err.Length == 0, err);
            Assert.IsTrue(System.IO.File.Exists(outputDesc.FilePath));
            return outputDesc;
        }

        public void FailExecute(string errMsg, string inputFilePath, string additionalParam = "")
        {
            FileManager tmpFile = new FileManager();
            string err = ExecuteProgram(inputFilePath, tmpFile, additionalParam);
            Assert.IsTrue(err.Length > 0);
            if (errMsg != null)
            {
                Assert.IsTrue(err.IndexOf(errMsg) >= 0);
            }
            Assert.IsFalse(System.IO.File.Exists(tmpFile.FilePath));
        }
    }
}
