﻿using System;
using System.Linq;
using System.Text;
using System.Collections.Generic;
using System.IO;
using TestUtility;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace MakeNroTest
{
    public class FileManager
    {
        private List<string> Buffer { get; set; }
        public string DirectoryPath { get; set; }
        public string FileName { get; set; }
        public bool IsWritten { get; set; }

        public string FilePath
        {
            get
            {
                return System.IO.Path.Combine(DirectoryPath, FileName);
            }
        }

        public FileManager()
        {
            this.FileName = System.IO.Path.GetRandomFileName();
            this.Buffer = new List<string>();
            this.DirectoryPath = System.IO.Directory.GetCurrentDirectory();
            IsWritten = false;
        }

        ~FileManager()
        {
            if (System.IO.File.Exists(FilePath))
            {
                System.IO.File.Delete(FilePath);
            }
        }

        public FileManager(string fileName)
        {
            this.FileName = fileName;
            this.Buffer = new List<string>();
        }

        public void AddLine(string line)
        {
            Buffer.Add(line);
        }

        public void DeleteLine(int index)
        {
            Buffer.RemoveAt(index);
        }

        public int FileLines()
        {
            return Buffer.Count;
        }

        public void WriteData()
        {
            Assert.IsFalse(IsWritten);
            Assert.IsFalse(System.IO.File.Exists(FilePath));
            using (System.IO.FileStream fs = System.IO.File.Create(FilePath))
            {
                using (System.IO.StreamWriter sw = new System.IO.StreamWriter(fs))
                {
                    foreach (var line in Buffer)
                    {
                        sw.WriteLine(line);
                    }
                }
            }
            IsWritten = true;
        }

        public byte[] ReadFile(int size, long offset)
        {
            byte[] buffer = new byte[size];
            Assert.IsTrue(System.IO.File.Exists(FilePath));
            using (FileStream fs = new FileStream(FilePath, FileMode.Open, FileAccess.Read))
            {
                fs.Seek(offset, SeekOrigin.Begin);
                int count = fs.Read(buffer, 0, size);
                Assert.IsTrue(count == size);
            }
            return buffer;
        }
    }
}
