﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <gtest/gtest.h>
#include <cstdarg>
#include <memory>
#include <vector>
#include <string>
#include <algorithm>

#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/cstd/cstd_CStdArg.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_TFormatString.h>
#include <nn/fs.h>

#include "MakeFatImage.h"
#include "utilTool_CommandLog.h"

namespace{

    void* Allocate(size_t size)
    {
        return malloc(size);
    }

    void Deallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
        return free(p);
    }

} // namespace

TEST(TestSparseImage, MakeFatImageTest)
{
    DefaultCommandLogObserver defaultObserver;
    defaultObserver.SetPositionDisplay(false);
    defaultObserver.SetLevel(CommandLogLevel_Debug);
    RegisterCommandLogObserver(defaultObserver);
    NN_UTIL_SCOPE_EXIT{ UnregisterCommandLogObserver(defaultObserver); };

    nn::fs::SetAllocator(Allocate, Deallocate);
    nn::fs::MountHostRoot();

    //-o "D:/home/siglo/tmp/SystemPartition.fatimage" - i "D:/home/siglo/tmp/FatRoot" --size 8 --debug
    NNT_EXPECT_RESULT_SUCCESS(
        MakeFatImage("D:/home/siglo/tmp/SystemPartition.fatimage", 8, "D:/home/siglo/tmp/FatRoot", true));


}
