﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using TestUtility;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace MakeDescTest
{
    [TestClass]
    public class TestOption : TestBase
    {
        [TestMethod]
        public void TestKernelVersion()
        {
            // 正常値
            // 10 進数のメジャーバージョンを受け取れる
            // 10 進数のマイナーバージョンを受け取れる
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                SuccessExecute(desc, null, "1.3");
            }

            // 16 進数のメジャーバージョンを受け取れない
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                FailExecute(null, desc, null, "0x1.3");
            }

            // メジャーバージョン最大値
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                SuccessExecute(desc, null, "8191.1");
            }

            // メジャーバージョン最小値
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                SuccessExecute(desc, null, "0.1");
            }

            // メジャーバージョン最大値 + 1
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                FailExecute(string.Format(MakeDesc.Properties.Resources.Message_ValueShouldBeUnsigned, "KernelVersion/MajorVersion", 13), desc, null, "8192.1");
            }

            // メジャーバージョン最小値 - 1
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                FailExecute(null, desc, null, "0x1.3");
            }

            // 16 進数のマイナーバージョンを受け取れない
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                FailExecute(null, desc, null, "0x1.3");
            }

            // マイナーバージョン最大値
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                SuccessExecute(desc, null, "1.15");
            }

            // マイナーバージョン最小値
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                SuccessExecute(desc, null, "1.0");
            }

            // マイナーバージョン最大値 + 1
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                FailExecute(string.Format(MakeDesc.Properties.Resources.Message_ValueShouldBeUnsigned, "KernelVersion/MinorVersion", 4), desc, null, "1.16");
            }

            // マイナーバージョン最小値 - 1
            {
                XmlFile desc = new XmlFile();
                XmlElement elem = new XmlElement("Desc");
                XmlElement defaultElem = CreateDefaultParam();
                elem.AddChild(defaultElem);

                desc.AddLine(elem.GetXml());
                desc.WriteData();
                FailExecute(null, desc, null, "0x1.3");
            }
        }
    }
}
