﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Interfaces;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// Test class that splits an input string to an output array of strings.
    /// </summary>
    public class SplitValueConverter : IValueConverter
    {
        /// <summary>
        /// Convert string to string array.
        /// </summary>
        /// <param name="value">String value.</param>
        /// <param name="targetType">The type to convert to.</param>
        /// <param name="parameter">A custom parameter.</param>
        /// <returns>Returns an array of strings.</returns>
        public object Convert(
            object value,
            Type targetType,
            object parameter)
        {
            var v = value as string;
            if (v == null)
            {
                return null;
            }

            return v.Split(new[] { ' ', '\t', '\r', '\n' }, StringSplitOptions.RemoveEmptyEntries);
        }

        /// <summary>
        /// Convert string array to string.
        /// </summary>
        /// <param name="value">String array value.</param>
        /// <param name="targetType">The type to convert to.</param>
        /// <param name="parameter">A custom parameter.</param>
        /// <returns>Returns a string.</returns>
        public object ConvertBack(
            object value,
            Type targetType,
            object parameter)
        {
            var v = value as string[];
            if (v == null)
            {
                return null;
            }

            return string.Join(" ", v);
        }
    }
}
