﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft2.h>
#include <nw/dw.h>
#include <nw/dw/dw_Controls.h>
#include <nw/eft/eft2_Callback.h>


namespace nw      {
namespace eftdemo {

//----------------------------------------
// 初期化
//----------------------------------------
void InitializePerfAnalyzer( nw::ut::MemoryAllocator* allocator, nw::internal::dw::WindowManager* manager, f32 width, f32 height );

//----------------------------------------
// 終了処理
//----------------------------------------
void FinalizePerfAnalyzer();

//----------------------------------------
// GPU処理コールバックリセット
//----------------------------------------
void ResetPerfAnalyzer();

//----------------------------------------
// GPUカウンタコールバック
//----------------------------------------
void PerfAnalyzerCallBack( nw::eft2::DrawEmitterProfilerArg& arg );

//----------------------------------------
// 処理
//----------------------------------------
u32 ProcessPerfAnalyzer( nw::eft2::EmitterSet* emitterSet );

} // namespace eftdemo
} // namespace nw
