﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <effectdemo.h>

#include <eftdemo_System.h>
#include <eftdemo_Light.h>

namespace nw      {
namespace eftdemo {


//---------------------------------------------------------------------------
//! @brief      キューブマップクラス
//---------------------------------------------------------------------------
class CubeMap
{
public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    CubeMap();

    //---------------------------------------------------------------------------
    //! @brief        初期化処理です。
    //---------------------------------------------------------------------------
    void Initialize( nw::ut::MemoryAllocator* allocator, f32 width, f32 height, void (*drawFunc)(EffectDemo*, DrawParam&, SimpleShader::ViewId) );

    //---------------------------------------------------------------------------
    //! @brief        描画処理です。
    //---------------------------------------------------------------------------
    void Draw( EffectDemo* effectDemo, const DrawParam& drawParam );

    //---------------------------------------------------------------------------
    //! @brief        カメラ位置を設定します。
    //---------------------------------------------------------------------------
    void SetPosition( const nw::math::VEC3& position )
    {
        mViewPos = position;
    }

    //---------------------------------------------------------------------------
    //! @brief        背景色を設定します。
    //---------------------------------------------------------------------------
    void SetColor(const nw::math::VEC4& color )
    {
        mBgColor = color;
    }

    //---------------------------------------------------------------------------
    //! @brief        キューブマップテクスチャを取得します。
    //---------------------------------------------------------------------------
//    nw::eft2::TextureResource GetCmTexture()
//    {
//#if defined(NW_PLATFORM_WIN32)
//        return mCmColor;
//#endif
//#if defined(NW_PLATFORM_CAFE)
//        return &mCmTexture;
//#endif
//    }

    //---------------------------------------------------------------------------
    //! @brief        キューブマップテクスチャを取得します。
    //---------------------------------------------------------------------------
#if defined(NW_PLATFORM_WIN32)
    GLuint* GetCmTextureArray()
    {
        return mCmColorArray;
    }
#endif
#if defined(NW_PLATFORM_CAFE)
    GX2Texture* GetCmTextureArray()
    {
        return mCmTextureArray;
    }
#endif

private:
    void (*m_drawFunc)(EffectDemo*, DrawParam&, SimpleShader::ViewId);  //!< 描画関数

    nw::math::VEC3  mViewPos;            //!< カメラ位置
    nw::math::VEC4  mBgColor;            //!< 背景色

    f32             mWidth;              //!< テクスチャの横幅
    f32             mHeight;             //!< テクスチャの縦幅

#if defined(NW_PLATFORM_WIN32)
    GLuint          mCmFbo;              //!< フレームバッファオブジェクト
    GLuint          mCmColor;            //!< カラーバッファ
    GLuint          mCmColorArray[6];    //!< スライス毎のカラーバッファ
    GLuint          mCmDepth;            //!< デプスバッファ
#endif
#if defined(NW_PLATFORM_CAFE)
    GX2Texture      mCmTexture;          //! テクスチャ
    GX2Texture      mCmTextureArray[6];  //! スライス毎のテクスチャ
    GX2ColorBuffer  mCmColorCube;        //! カラーバッファ
    GX2ColorBuffer  mCmColorArray[6];    //! スライス毎のカラーバッファ
    GX2DepthBuffer  mCmDepth;            //! デプスバッファ
#endif
};


} // namespace eftdemo
} // namespace nw
