﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConverterTestApp
{
    internal class Utility
    {
        // プロセスの出力ログ用
        private static readonly StringBuilder Output = new StringBuilder();

        /// <summary>
        /// 子プロセスが標準出力に出力したときに呼び出されるメソッド
        /// </summary>
        private static void OutputHandler(object o, DataReceivedEventArgs args)
        {
            Output.AppendLine(args.Data); // 出力されたデータを保存
        }

        /// <summary>
        /// コマンド実行
        /// </summary>
        /// <param name="exePath">実行するexeのファイルパス</param>
        /// <param name="arg">プロセスに渡す引数</param>
        public static bool ExecuteCommand(string exePath, string arg)
        {
            using (var process = new Process())
            {
                process.StartInfo.FileName = exePath;
                process.StartInfo.Arguments = arg;

                process.StartInfo.CreateNoWindow = true;
                process.StartInfo.UseShellExecute = false;
                process.StartInfo.RedirectStandardInput = true;
                process.StartInfo.RedirectStandardOutput = true;
                process.StartInfo.RedirectStandardError = true;

                process.OutputDataReceived += OutputHandler;

                // 実行
                process.Start();
                // 子プロセスの出力読み込み開始
                process.BeginOutputReadLine();
                // 終了待ち
                process.WaitForExit();

                // 出力ログを表示
                Console.WriteLine(Output);

                if (process.ExitCode == 0)
                {
                    process.Dispose();
                    return false;
                }

                process.Dispose();
                return true;
            }
        }

        /// <summary>
        /// ファイルの存在チェック
        /// </summary>
        /// <param name="filePath">ファイルパス</param>
        public static bool CheckFile(string filePath)
        {
            if (!File.Exists(filePath))
            {
                Console.WriteLine("ファイルが見つかりません：" + filePath);
                return false;
            }
            return true;
        }
    }
}
