﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DevMenuCommandTest
{
    public class RunOnTarget
    {
        private string m_ExePath;
        private string m_RunOnTargetPath;

        private string m_Target { get; set; }

        public bool IsVerboseLogEnabled { get; set; }

        public RunOnTarget(TestContext context, string exePath, string target)
        {
            m_ExePath = exePath;
            IsVerboseLogEnabled = false;
            m_Target = target;
            var sigloRoot = new TestUtility.TestPath(context).GetSigloRoot();

            m_RunOnTargetPath = sigloRoot +
                "\\Tools\\CommandLineTools\\RunOnTarget.exe";
        }

        public Tuple<bool, StringBuilder, StringBuilder> Execute(string args, bool doReset, IEnumerable<string> additionalOptions)
        {
            string addtionalOptionString = additionalOptions != null ? (string.Join(" ", additionalOptions) + " ") : "";

            using (var process = new Process())
            {
                var resetOption = doReset ? " --reset " : "";
                var verboseOption = IsVerboseLogEnabled ? " --verbose " : "";
                var arguments = resetOption +
                                verboseOption +
                                (string.IsNullOrEmpty(m_Target) ? "" : " -t " + m_Target) +
                                " " + m_ExePath +
                                " " + addtionalOptionString +
                                "-- " +
                                args;

                var outputs = ProcessManager.SetupProcess(process, m_RunOnTargetPath, arguments);
                ProcessManager.RunAndWaitProcess(process);

                return new Tuple<bool, StringBuilder, StringBuilder>(process.ExitCode == 0, outputs.Item1, outputs.Item2);
            }
        }
    }
}
