﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <stddef.h>
#include <stdint.h>

// ストレージクラスの位置に関するテストです。
void Position()
{
    class Correct
    {
    private:
        mutable int                    n1;
        mutable signed int             n2;
        mutable unsigned int           n3;
        mutable volatile int           n9;
        mutable volatile signed int    n10;
        mutable volatile unsigned int  n11;
    };

    class Incorrect
    {
    private:
        int mutable                   n1;  //:) BAD
        signed int mutable            n2;  //:) BAD
        unsigned mutable int          n3;  //:) BAD
        volatile mutable int          n9;  //:) BAD
        volatile signed int mutable   n10; //:) BAD
        volatile unsigned mutable int n11; //:) BAD
    };

    {
        int                    n1;
        signed int             n2;
        unsigned int           n3;
        auto                   n4   = 4;
        const int              n5   = 5;
        const signed int       n6   = 6;
        const unsigned int     n7   = 7;
        const auto             n8   = 8;
        volatile int           n9;
        volatile signed int    n10;
        volatile unsigned int  n11;
        volatile auto          n12  = 12;
    }
    {
        extern int                    n1;
        extern signed int             n2;
        extern unsigned int           n3;
        extern volatile int           n9;
        extern volatile signed int    n10;
        extern volatile unsigned int  n11;
    }
    {
        register int                    n1;
        register signed int             n2;
        register unsigned int           n3;
        register auto                   n4   = 4;
        register const int              n5   = 5;
        register const signed int       n6   = 6;
        register const unsigned int     n7   = 7;
        register const auto             n8   = 8;
        register volatile int           n9;
        register volatile signed int    n10;
        register volatile unsigned int  n11;
        register volatile auto          n12  = 12;
    }
    {
        static int                    n1;
        static signed int             n2;
        static unsigned int           n3;
        static auto                   n4   = 4;
        static const int              n5   = 5;
        static const signed int       n6   = 6;
        static const unsigned int     n7   = 7;
        static const auto             n8   = 8;
        static volatile int           n9;
        static volatile signed int    n10;
        static volatile unsigned int  n11;
        static volatile auto          n12  = 12;
    }
    {
        thread_local int                    n1;
        thread_local signed int             n2;
        thread_local unsigned int           n3;
        thread_local auto                   n4   = 4;
        thread_local const int              n5   = 5;
        thread_local const signed int       n6   = 6;
        thread_local const unsigned int     n7   = 7;
        thread_local const auto             n8   = 8;
        thread_local volatile int           n9;
        thread_local volatile signed int    n10;
        thread_local volatile unsigned int  n11;
        thread_local volatile auto          n12  = 12;
    }
    {
        int extern                    n1;        //:) BAD
        signed extern int             n2;        //:) BAD
        unsigned int extern           n3;        //:) BAD
        volatile int extern           n9;        //:) BAD
        volatile extern signed int    n10;       //:) BAD
        volatile unsigned extern int  n11;       //:) BAD
    }
    {
        int register                    n1;        //:) BAD
        signed register int             n2;        //:) BAD
        unsigned int register           n3;        //:) BAD
        auto register                   n4   = 4;  //:) BAD
        const int register              n5   = 5;  //:) BAD
        const register signed int       n6   = 6;  //:) BAD
        const unsigned register int     n7   = 7;  //:) BAD
        const auto register             n8   = 8;  //:) BAD
        volatile int register           n9;        //:) BAD
        volatile register signed int    n10;       //:) BAD
        volatile unsigned register int  n11;       //:) BAD
        volatile auto register          n12  = 12; //:) BAD
    }
    {
        int static                    n1;        //:) BAD
        signed static int             n2;        //:) BAD
        unsigned int static           n3;        //:) BAD
        auto static                   n4   = 4;  //:) BAD
        const int static              n5   = 5;  //:) BAD
        const static signed int       n6   = 6;  //:) BAD
        const unsigned static int     n7   = 7;  //:) BAD
        const auto static             n8   = 8;  //:) BAD
        volatile int static           n9;        //:) BAD
        volatile static signed int    n10;       //:) BAD
        volatile unsigned static int  n11;       //:) BAD
        volatile auto static          n12  = 12; //:) BAD
    }
    {
        int thread_local                    n1;        //:) BAD
        signed thread_local int             n2;        //:) BAD
        unsigned int thread_local           n3;        //:) BAD
        auto thread_local                   n4   = 4;  //:) BAD
        const int thread_local              n5   = 5;  //:) BAD
        const thread_local signed int       n6   = 6;  //:) BAD
        const unsigned thread_local int     n7   = 7;  //:) BAD
        const auto thread_local             n8   = 8;  //:) BAD
        volatile int thread_local           n9;        //:) BAD
        volatile thread_local signed int    n10;       //:) BAD
        volatile unsigned thread_local int  n11;       //:) BAD
        volatile auto thread_local          n12  = 12; //:) BAD
    }
}

// ストレージクラスの型名に関するテストです。
void TypeName()
{
    typedef uint8_t  Bit8;
    typedef uint16_t Bit16;
    typedef uint32_t Bit32;
    typedef uint64_t Bit64;
    typedef uint8_t  BitPack8;
    typedef uint16_t BitPack16;
    typedef uint32_t BitPack32;
    typedef uint64_t TimeSpan;

    {
        void*      varVoidPointer;
        bool       varBool;
        char       varChar;
        short      varShort;
        int        varInt;
        long       varLong;
        float      varFloat;
        double     varDouble;
        int8_t     varInt8;
        int16_t    varInt16;
        int32_t    varInt32;
        int64_t    varInt64;
        uint8_t    varUint8;
        uint16_t   varUint16;
        uint32_t   varUint32;
        uint64_t   varUint64;
        size_t     varSize;
        ptrdiff_t  varPtrDiff;
        uintptr_t  varUintPtr;
        char16_t   varChar16;
        char32_t   varChar32;
        BitPack8   varBitPack8;
        BitPack16  varBitPack16;
        BitPack32  varBitPack32;
        Bit8       varBit8;
        Bit16      varBit16;
        Bit32      varBit32;
        Bit64      varBit64;
        TimeSpan   varTimeSpan;
    }

    {
        void       extern *varVoidPointer; //:) BAD
        bool       extern varBool;         //:) BAD
        char       extern varChar;         //:) BAD
        short      extern varShort;        //:) BAD
        int        extern varInt;          //:) BAD
        long       extern varLong;         //:) BAD
        float      extern varFloat;        //:) BAD
        double     extern varDouble;       //:) BAD
        int8_t     extern varInt8;         //:) BAD
        int16_t    extern varInt16;        //:) BAD
        int32_t    extern varInt32;        //:) BAD
        int64_t    extern varInt64;        //:) BAD
        uint8_t    extern varUint8;        //:) BAD
        uint16_t   extern varUint16;       //:) BAD
        uint32_t   extern varUint32;       //:) BAD
        uint64_t   extern varUint64;       //:) BAD
        size_t     extern varSize;         //:) BAD
        ptrdiff_t  extern varPtrDiff;      //:) BAD
        uintptr_t  extern varUintPtr;      //:) BAD
        char16_t   extern varChar16;       //:) BAD
        char32_t   extern varChar32;       //:) BAD
        BitPack8   extern varBitPack8;     //:) BAD
        BitPack16  extern varBitPack16;    //:) BAD
        BitPack32  extern varBitPack32;    //:) BAD
        Bit8       extern varBit8;         //:) BAD
        Bit16      extern varBit16;        //:) BAD
        Bit32      extern varBit32;        //:) BAD
        Bit64      extern varBit64;        //:) BAD
        TimeSpan   extern varTimeSpan;     //:) BAD
    }
}
