﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using CodingCheckerUtil;
using System;
using System.IO;
using System.Text;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace GitHookTest
{
    [TestClass]
    public class CommitMsgMergeTest
    {
        public TestContext TestContext { get; set; }
        private GitHookTestContext m_GitHookTestContext { get; set; }
        private const string JIRA_KEY = "SIGLO-0";

        [TestInitialize]
        public void Initialize()
        {
            m_GitHookTestContext = new GitHookTestContext(TestContext);
        }

        [TestCleanup]
        public void CleanUp()
        {
            m_GitHookTestContext.Dispose();
        }

        [TestMethod]
        public void IgnoreAutoMergeCommitTest()
        {
            string testFile = Path.Combine(m_GitHookTestContext.TestLocalRepositoryDirectory, "test.cpp");
            string testFile2 = Path.Combine(m_GitHookTestContext.TestLocalRepositoryDirectory, "test2.cpp");
            string testFile3 = Path.Combine(m_GitHookTestContext.TestLocalRepositoryDirectory, "test3.cpp");
            File.WriteAllText(testFile, "test.", new UTF8Encoding(true));
            File.WriteAllText(testFile2, "test2.", new UTF8Encoding(true));

            // リモートへとコミットをプッシュ
            m_GitHookTestContext.ExecuteGit($"add \"{testFile}\"");
            m_GitHookTestContext.ExecuteGit($"commit -m \"({JIRA_KEY}) init commit\"");
            m_GitHookTestContext.ExecuteGit($"add \"{testFile2}\"");
            m_GitHookTestContext.ExecuteGit($"commit -m \"({JIRA_KEY}) test commit for remote\"");
            m_GitHookTestContext.ExecuteGit($"push");

            // 初期コミットまでリセットしてローカルブランチ作成
            m_GitHookTestContext.ExecuteGit($"reset --hard HEAD^");
            m_GitHookTestContext.ExecuteGit($"checkout -b testBranch");

            // ローカルブランチ側に別の変更をコミット
            File.WriteAllText(testFile3, "test3.", new UTF8Encoding(true));
            m_GitHookTestContext.ExecuteGit($"add \"{testFile3}\"");
            m_GitHookTestContext.ExecuteGit($"commit -m \"({JIRA_KEY}) test commit for local\"");

            // Git for Windows 2.15.0 以降では、自動マージ時に commit-msg が実行される (SIGLO-79119)
            // 自動マージ時のデフォルトコミットメッセージに対して、
            // コミットログチェックでエラーとならないことを確認
            m_GitHookTestContext.ExecuteGit($"merge origin/master");
        }
    }
}
