﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using CodingCheckerUtil;
using System;
using System.IO;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CodingCheckerUtilTest
{
    [TestClass]
    public class GitExecuterTest
    {
        [TestMethod]
        public void CanSuccessfullyExecuteValidSubcommand()
        {
            var gitPath = TestUtils.GetGitExecutablePath();
            Assert.IsNotNull(gitPath);

            var sut = new PrivateObject(new GitExecuter(gitPath));

            var output = (string)sut.Invoke("Execute", "--version");
            Assert.IsTrue(output.Contains("version"));
        }

        [TestMethod]
        public void CanSuccessfullyExecuteForBytesValidSubcommand()
        {
            var gitPath = TestUtils.GetGitExecutablePath();
            Assert.IsNotNull(gitPath);

            var sut = new PrivateObject(new GitExecuter(gitPath));

            var output = (byte[])sut.Invoke("ExecuteForBytes", "--version");
            Assert.IsTrue(new UTF8Encoding().GetString(output).Contains("version"));
        }

        [TestMethod]
        [ExpectedException(typeof(GitExecuterException))]
        public void ThrowsExceptionWhenFailsToExecute()
        {
            var sut = new PrivateObject(new GitExecuter(Path.Combine(Path.GetTempPath(), "nonexistentpath.exe")));

            sut.Invoke("Execute", string.Empty);
        }

        [TestMethod]
        [ExpectedException(typeof(GitExecuterException))]
        public void ThrowsExceptionWhenGitReturnsError()
        {
            var gitPath = TestUtils.GetGitExecutablePath();
            Assert.IsNotNull(gitPath);

            var sut = new PrivateObject(new GitExecuter(gitPath));

            sut.Invoke("Execute", "nonexistentsubcomand");
        }
    }
}
