# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from kiki.util.log import file_logger as logger

class MiiHairstyleEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiEditor, self).__init__(driver)


    def select_hairstyle_parts(self,id):
        id_pos ={
            0:[150,235],
            1:[242,235],
            2:[334,235],
            3:[426,235],
            4:[518,235],
            5:[610,235],
            6:[150,320],
            7:[242,320],
            8:[334,320],
            9:[426,320],
            10:[518,320],
            11:[610,320],
            12:[150,410],
            13:[242,410],
            14:[334,410],
            15:[426,410],
            16:[518,410],
            17:[610,410],
            18:[150,500],
            19:[242,500],
            20:[334,500],
            21:[426,500],
            22:[518,500],
            23:[610,500],
            24:[150,595],
            25:[242,595],
            26:[334,595],
            27:[426,595],
            28:[518,595],
            29:[610,595],
        }

        self.driver.screen.touch(0,x=270 ,y= 85 ,ms_after = 500)

        page_id_pos = 260 + 50 * int(id / 30)
        self.driver.screen.touch(0,x=60 ,y= page_id_pos ,ms_after = 500)

        icon_id = id % 30
        self.driver.screen.touch(0,x=id_pos[icon_id][0],y=id_pos[icon_id][1], ms_after=500)

    def set_hairstyle_settings(self,hairstyle_parts_id,hairstyle_color_id):
        if hairstyle_parts_id is not None : self.select_hairstyle_parts(hairstyle_parts_id)
        if hairstyle_color_id is not None : self.select_color_of_parts(hairstyle_color_id)
        self.back_to_edit_menu()
