# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from scenes.t_base_scene import TBaseScene


class TOptionMenu(TBaseScene):
    def __init__(self, driver):
        super(TOptionMenu, self).__init__(driver)


    def is_available(self):
        pass

    def select_navi_bar(self, name, id=0):
        navi_dict = { "ソフトの情報": 0,
                      "ソフトの更新": 1,
                      "データ管理": 2,
                      "マイニンテンドーポイントプログラム": 3}

        self.driver.controllers[id].push("UP", ms_press=1000, ms_after=1000)
        for i in range(navi_dict[name]):
            self.driver.controllers[id].push("DOWN", ms_after=500)
        self.driver.controllers[id].push("A", ms_after=1000)

    def select_menu(self, name, id=0):
        menu_dict = { "ニンテンドーeショップへ": [ "ソフトの情報", 0 ],
                      "お問い合わせ先": [ "ソフトの情報", 1 ],
                      "重要な情報": [ "ソフトの情報", 2 ],
                      "知的財産の表記": [ "ソフトの情報", 3 ],
                      "インターネットで更新": [ "ソフトの更新", 0 ],
                      "近くの人から更新": [ "ソフトの更新", 1 ],
                      "データの整理": [ "データ管理", 0 ],
                      "ソフトの消去": [ "データ管理", 1 ],
                      "ポイントを受け取る": [ "マイニンテンドーポイントプログラム", 0] }

        self.select_navi_bar(menu_dict[name][0])
        for i in range(menu_dict[name][1]):
            self.driver.controllers[id].push("DOWN", ms_after=500)
        self.driver.controllers[id].push("A", ms_after=1000)