# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time
import datetime
from params.winpos import WIN_POS
from scenes.base_scene import BaseScene
from res.res_path import RES_PATH

from kiki.util.log import file_logger as logger
from scenes.main_setting.main_setting import MainSetting
from HACDllDriver import factory, Button, CaptureMode
from scenes.t_base_scene import TBaseScene

_ICON_IMAGE_PATH = RES_PATH + "/home_menu/"



class THomeMenu(TBaseScene):
    def __init__(self, driver):
        super(THomeMenu, self).__init__(driver)

    def is_available(self):
        setting_icon = _ICON_IMAGE_PATH + "setting_icon.png"
        if self.driver.screen.detect_object_with_image(setting_icon) is not None:
            return True
        else:
            return False

    def select_system_applet(self, app_name, id=0):
        app_icon_dict = {
            "news_list": 0,
            "eShop": 1,
            "album": 2,
            "controller": 3,
            "main_setting": 4,
            "sleep": 5
        }

        logger.info(app_name + "へ遷移します")

        self.driver.controllers[id].push("DOWN", ms_after=1000)
        for i in range(app_icon_dict[app_name]):
            self.driver.controllers[id].push("RIGHT", ms_after=500)
        self.driver.controllers[id].push("A", ms_after=1000)

    def transit_to_sleep_mode(self, id=0):
        self.select_system_applet("sleep", id)
        self.driver.controllers[id].push("A", ms_after=1000)

    def search_card_title(self, id=0):
        self.driver.controllers[id].push("HOME", ms_after=500)
        image = _ICON_IMAGE_PATH + "icon_cardgame.png"
        for i in range(12):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                self.driver.controllers[id].push("RIGHT", ms_after=500)
        else:
            return False

    def check_already_registered_parental_control(self):
        image = _ICON_IMAGE_PATH + "registered_parental_control_identity.png"
        if self.driver.screen.detect_object_with_image(image) is not None:
            return True
        else:
            return False

    def boot_app_from_qlaunch(self, img_path, id=0, threshold=0.95):
        self.driver.controllers[id].push("HOME", ms_after=1000)

        if type(img_path) == list:
            for i in range(11):
                for img in img_path:
                    if self.driver.screen.detect_object_with_image(img, threshold=threshold) is not None:
                        self.driver.controllers[id].push("A", ms_after=1000)
                        return True
                self.driver.controllers[id].push("RIGHT", ms_after=1000)
            else:
                return False
        else:
            for i in range(11):
                if self.driver.screen.detect_object_with_image(img_path, threshold=threshold) is not None:
                    self.driver.controllers[id].push("A", ms_after=1000)
                    return True
            else:
                return False

    def is_connected_AP_from_system_infomation(self):
        image = _ICON_IMAGE_PATH + "system_info_any_registered_AP.png"
        for i in range(10):
            if self.driver.screen.detect_object_with_image(image, threshold=0.99) is not None:
                time.sleep(1)
            else:
                return True
        else:
            return False

if __name__ == "__main__":
    logger.info("program start")
    logger.info("============================================")

    with factory(*WIN_POS, capture=CaptureType.AmaRec, is_open_logreader=False) as _driver:
        _driver.controllers.add(0)
        time.sleep(3)
        _scene = THomeMenu(_driver)
        print(_scene.is_connected_AP_from_system_infomation())
        print("end")