# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time
import datetime
from params.winpos import WIN_POS
from scenes.home_menu.home_menu import HomeMenu
from scenes.home_menu.sandbox import SandBox
from res.res_path import RES_PATH

from kiki.util.log import file_logger as logger
from scenes.main_setting.main_setting import MainSetting

_ICON_IMAGE_PATH = RES_PATH + "/home_menu/"

class FullLauncher(HomeMenu):
    def __init__(self, driver):
        super(FullLauncher, self).__init__(driver)

    def is_available(self):
        icon_image_list = [
                           _ICON_IMAGE_PATH + "ss_fulllauncher_identity_icon.png",
                            ]

        for icon_image in icon_image_list:
            if self.driver.screen.detect_object_with_image(icon_image) is not None:
                return True
        else:
            return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してHOMEにいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<qlaunch\>.*\[ResidentMenu\].*\[Started\].*\[SceneFLaunch\]"
                                         , ms_timeout=10000,is_reverse=False)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def search_icon(self, icon_image_list, threshold=0.8, repeat_num=10, shows_result=False):
        """フルランチャーからアイコンを探す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        self.driver.controllers[0].push("UP", ms_press=3000, ms_after=500)
        icon_image = []
        for icon in icon_image_list:
            icon_image.append(_ICON_IMAGE_PATH + icon)

        for i in range(repeat_num):
            result = self._search_icon_from_image_list(icon_image, shows_result=shows_result)
            if result is not None:
                logger.info("アイコン発見")
                return result
            elif self.check_cannot_scroll_below():
                # これ以上、下にはスクロールできない
                logger.info("これ以上、下にスクロールできません。")
                return None
            else:
                self.driver.controllers[0].push("DOWN", ms_after=1000)

        logger.info("アイコン見つからなかった…")
        return None

    def check_cannot_scroll_below(self):
        x_pos = 1265
        y_pos = 640
        color = (208, 208, 208)

        return self.driver.screen.check_color_dot(x_pos, y_pos, color, color_range=4)
