# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from scenes.base_scene import BaseScene
from kiki.util.log import file_logger as logger
from params.winpos import WIN_POS
from res.res_path import RES_PATH

import time

_ICON_IMAGE_PATH = RES_PATH + "/controller_support/"

class ControllerSupport(BaseScene):
    def __init__ (self,driver):
        super(ControllerSupport,self).__init__(driver)

    def is_available(self):
        icon = _ICON_IMAGE_PATH + "ss_consup_icon.png"
        if self.driver.screen.detect_object_with_image(icon, threshold=0.9) is not None:
            return True
        else:
            return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してコンサポにいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<controller\>.*approveInitialDraw"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def make_available_controllers(self, cont_id=0, cont_type=ContType.FULL):
        # 指定された cont_id 番のコントローラーを使用可能にします。
        if type(cont_id) == list:
            for add_id in cont_id:
                self.driver.controllers[add_id].push("RIGHT", ms_after=800)
        else:
            self.driver.controllers[cont_id].push("RIGHT", ms_after=500)