# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time
from abc import ABCMeta, abstractmethod

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH

_ICON_IMAGE_PATH = RES_PATH + "/base_scene/"

class BaseScene(object):
    __metaclass__ = ABCMeta

    def __init__(self, hac_driver):
        self.driver = hac_driver

    @abstractmethod
    def is_available(self):
        pass

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    #===========================
    # 電源メニュー
    #===========================
    def power_menu_is_available_from_log(self, logstore):
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<overlayDisp\>.*\[ducking\] enter SleepMenu.*",
                                         ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def select_reboot_button(self, logstore):
        # 電源メニュー起動直後の状態から、再起動を選びます
        # 再起動選択後、ある程度(2秒くらい？)ログが出て TargetManager は未接続に。
        # log_store.close()忘れずに。
        self.driver.controllers[0].push("DOWN", ms_after=500)
        self.driver.controllers[0].push("A", ms_after=500)

        # 再起動選択のA押下
        logstore.move_pointer_newest()
        self.driver.controllers[0].push("A")
        match = logstore.read_line_until(reg_str="\<overlayDisp\>.*send SystemAppletMessage \[RequestReboot\]",
                                         ms_timeout=2000)
        result = False
        if match is not None:
            logger.info("電源メニューから再起動を実行しました。")
            result = True
        else:
            logger.info("電源メニューから再起動を実行できていない可能性があります。")

        self.driver.log_reader.close()
        return result

    #===========================
    # NUPを促すダイアログ表示
    #===========================
    def is_available_required_sysup_dialog(self):
        icon_name_list = ["ss_required_system_update_JP.png",
                           "ss_required_system_update_US_EU.png"]
        for icon_name in icon_name_list:
            icon = _ICON_IMAGE_PATH + icon_name
            if self.driver.screen.detect_object_with_image(icon) is not None:
                return True
        return False

    #===========================
    # NA連携 Basic認証表示
    #===========================
    def is_available_user_authentication(self):
        icon_name_list = ["ss_user_authentication_JP.png",
                          "ss_user_authentication_US_EU.png"]
        for icon_name in icon_name_list:
            icon = _ICON_IMAGE_PATH + icon_name
            if self.driver.screen.detect_object_with_image(icon) is not None:
                # NA連携するころにはcruiser？のシーンオブジェクト返してあげてもいいかもしれない。
                return True
        return False

    def input_user_authentication(self, driver, language, logstore):
        # とりあえず入力情報が保存されていない時の操作
        from scenes.common.swkbd import Swkbd

        self.driver.controllers[0].push("A", ms_after=500)
        scene = Swkbd(driver)
        time.sleep(1)
        scene.swkbd_input_str("nintendo", language, logstore)
        scene.swkbd_input_enter()
        time.sleep(1)
        self.driver.controllers[0].push("A", ms_after=500)
        time.sleep(1)
        scene.swkbd_input_str("", language, logstore)
        scene.swkbd_input_enter()
        time.sleep(1)

    #================================
    # SDEV ミラーリング機能 情報表示
    #================================
    def is_info_indication(self):
        icon_name_list = ["ss_hardware_info.png"]

        for icon_name in icon_name_list:
            icon = _ICON_IMAGE_PATH + icon_name
            if self.driver.screen.detect_object_with_image(icon, threshold=0.95) is not None:
                return True
        return False