﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using Nintendo.Authoring.AuthoringEditor.SelectTwoNspFilesWindow;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.SelectTwoNspFilesWindow
{
    public class ComparableFileTypeTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        public static IEnumerable<object[]> AllComparableFileType =>
            Enum.GetValues(typeof(ComparableFileType)).Cast<ComparableFileType>().Select(t => new object[] {t});

        [Theory]
        [InlineData(ComparableFileType.PatchNspExtractedDirectory, true)]
        [InlineData(ComparableFileType.AppMeta, false)]
        [InlineData(ComparableFileType.AppNsp, true)]
        [InlineData(ComparableFileType.AocMeta, false)]
        [InlineData(ComparableFileType.AocNsp, true)]
        [InlineData(ComparableFileType.Detecting, false)]
        [InlineData(ComparableFileType.NotFound, false)]
        [InlineData(ComparableFileType.NotOriginalAppNspFile, false)]
        [InlineData(ComparableFileType.NotSet, false)]
        [InlineData(ComparableFileType.PatchNsp, true)]
        [InlineData(ComparableFileType.Unknown, false)]
        public void IsNsp(ComparableFileType type, bool isNsp)
        {
            Assert.Equal(isNsp, type.IsNsp());
        }

        [Theory]
        [MemberData(nameof(AllComparableFileType))]
        public void IsMeta(ComparableFileType type)
        {
            var sign = type.ToString().EndsWith("Meta");

            Assert.Equal(sign, type.IsMeta());
        }

        [Theory]
        [InlineData(ComparableFileType.AocMeta)]
        [InlineData(ComparableFileType.AppMeta)]
        [InlineData(ComparableFileType.AppNsp)]
        [InlineData(ComparableFileType.PatchNsp)]
        [InlineData(ComparableFileType.PatchNspExtractedDirectory)]
        [InlineData(ComparableFileType.AocNsp)]
        public void IsComprableType_SameType(ComparableFileType t)
        {
            Assert.True(t.IsComparable(t));
        }

        [Fact]
        public void IsComprableType_AppAndPatch()
        {
            Assert.False(ComparableFileType.AocNsp.IsComparable(ComparableFileType.AppNsp));
            Assert.False(ComparableFileType.AppNsp.IsComparable(ComparableFileType.AocNsp));

            Assert.True(ComparableFileType.PatchNsp.IsComparable(ComparableFileType.AppNsp));
            Assert.True(ComparableFileType.AppNsp.IsComparable(ComparableFileType.PatchNsp));

            Assert.True(ComparableFileType.AppNsp.IsComparable(ComparableFileType.PatchNspExtractedDirectory));
            Assert.True(ComparableFileType.PatchNspExtractedDirectory.IsComparable(ComparableFileType.AppNsp));

            Assert.True(ComparableFileType.PatchNsp.IsComparable(ComparableFileType.PatchNspExtractedDirectory));
            Assert.True(ComparableFileType.PatchNspExtractedDirectory.IsComparable(ComparableFileType.PatchNsp));
        }
    }
}
