﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Core.Test.Fixtures;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Nintendo.Authoring.AuthoringEditor.NspEntriesWindow;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.NspEntriesWindow
{
    public class NspEntriesWindowVmTest : IDisposable, IClassFixture<BuildTestAppNspFixture>
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        private readonly BuildTestAppNspFixture _fixture;

        public NspEntriesWindowVmTest(BuildTestAppNspFixture fixture)
        {
            _fixture = fixture.Initialize();
        }

        [Fact]
        public void DefaultCtor()
        {
            var nspFile = new NspFile(_fixture.NspFilePath);
            using (var vm = new NspEntriesWindowVm(new Project{ NspFile = nspFile }))
            {
                Assert.NotNull(vm.CloseCommand);
                Assert.NotNull(vm.OpenByAssociationAppCommand);

                Assert.NotNull(vm.Root);
                Assert.NotNull(vm.SelectedItems);
                Assert.Empty(vm.SelectedItems);

                Assert.NotNull(vm.IsExtracting);
                Assert.NotNull(vm.IsInMakeFileTree);
            }
        }

        [Fact]
        public void CloseCommand()
        {
            var nspFile = new NspFile(_fixture.NspFilePath);
            using (var vm = new NspEntriesWindowVm(new Project { NspFile = nspFile }))
            {
                vm.CloseCommand.Execute();
            }
        }

        [Fact]
        public void OpenByAssociationAppCommand()
        {
            var nspFile = new NspFile(_fixture.NspFilePath);
            using (var vm = new NspEntriesWindowVm(new Project { NspFile = nspFile }))
            {
                vm.OpenByAssociationAppCommand.Execute(null);
            }
        }
    }
}
