﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages;
using Xunit;
using static Nintendo.Authoring.AuthoringEditor.Properties.Resources;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Pages
{
    public class PlayLogsPageVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        private ApplicationCapability Capability => _context.DiContainer.GetInstance<ApplicationCapability>();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<PlayLogsPageVm>())
            {
                if (Capability.IsSupportPlayLogs)
                {
                    Assert.NotEmpty(vm.Params);
                }
                else
                {
                    Assert.Empty(vm.Params);
                }
            }
        }

        [Theory]
        [InlineData(PlayLogQueryCapabilityType.All, true)]
        [InlineData(PlayLogQueryCapabilityType.None, false)]
        [InlineData(PlayLogQueryCapabilityType.WhiteList, false)]
        public void PlayLogQueryCapabilityVisibility(PlayLogQueryCapabilityType capabilityType, bool visibleCapabilityTypeSelection)
        {
            if (!Capability.IsSupportPlayLogs)
                return;
            using (var project = _context.DiContainer.GetInstance<Project>())
            {
                project.Meta.Application.PlayLogQueryCapability = capabilityType;
                using (var vm = _context.DiContainer.GetInstance<PlayLogsPageVm>())
                {
                    Assert.Equal(
                        visibleCapabilityTypeSelection,
                        vm.Params.Any(p => p.CaptionTag == nameof(PlayLogQueryCapability_Caption)));
                }
            }
        }
    }
}
