﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Pages
{
    public class NspSizePageVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor_Empty()
        {
            using (var vm = _context.DiContainer.GetInstance<NspSizePageVm>())
            {
                Assert.Empty(vm.Params);

                Assert.Null(vm.DownloadSize);
                Assert.Null(vm.ApplicationUsedAreaOnCard);
                Assert.Null(vm.ApplicationAvailableAreaOnCard);
                Assert.Null(vm.MinimumSaveDataSize);
                Assert.Null(vm.EachUserAccountSaveDataSize);
            }
        }

        [Fact]
        public void DefaultCtor()
        {
            var project = _context.DiContainer.GetInstance<Project>();

            project.ContentMetaProperties.Properties.Add(new ContentMetaProperty
            {
                Type = ContentMetaType.Application,
                Size = new ContentMetaSizeProperty()
            });

            using (var vm = _context.DiContainer.GetInstance<NspSizePageVm>())
            {
                Assert.Equal(5, vm.Params.Length);

                Assert.NotNull(vm.DownloadSize);
                Assert.NotNull(vm.ApplicationUsedAreaOnCard);
                Assert.NotNull(vm.ApplicationAvailableAreaOnCard);
                Assert.NotNull(vm.MinimumSaveDataSize);
                Assert.NotNull(vm.EachUserAccountSaveDataSize);
            }
        }
    }
}
