﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Nintendo.Authoring.AuthoringEditor.Properties;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Pages
{
    public class AreaCaptionTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        public static IEnumerable<object[]> CtorTestData
        {
            get
            {
                yield return new object[] {null, null};
                yield return new object[] {null, ""};
                yield return new object[] {Resources.America, nameof(Resources.America)};
            }
        }

        [Theory]
        [MemberData(nameof(CtorTestData))]
        public void Ctor(string actual, string tag)
        {
            var a = new AreaCaption(tag);

            Assert.Equal(a.Caption, actual);
        }
    }
}
