﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Nintendo.Authoring.AuthoringEditor.Convertes;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.Converters
{
    public class ToUnicodeStringLengthConverterTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            // ReSharper disable once ObjectCreationAsStatement
            new EnumToCaptionConverter();
        }

        public static IEnumerable<object[]> ConvertTestData
        {
            get
            {
                yield return new object[] {"0", null};
                yield return new object[] {"0", string.Empty};
                yield return new object[] {"3", "abc"};
                yield return new object[] {"0", 123};
                yield return new object[] {"1", "\uD867\uDE3D" };  // ほっけ
            }
        }

        [Theory]
        [MemberData(nameof(ConvertTestData))]
        public void Convert(string expected, object value)
        {
            var c = new ToUnicodeStringLengthConverter();

            Assert.Equal(expected, c.Convert(value, null, null, null));
        }

        [Fact]
        public void ConvertBack()
        {
            var c = new ToUnicodeStringLengthConverter();

            Assert.Throws<NotImplementedException>(() => c.ConvertBack(null, null, null, null));
        }
    }
}
