﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using nw.g3d.nw4f_3dif;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _3dToolsTestUtility
{
    public static class AnimDataCreationUtility
    {
        public static skeletal_animType CreateEmptySkeletalAnim()
        {
            return new skeletal_animType()
            {
                skeletal_anim_info = new skeletal_anim_infoType()
                {
                },
                bone_anim_array = new bone_anim_arrayType()
                {
                    bone_anim = new bone_animType[0]
                },
                stream_array = new stream_arrayType()
                {
                    stream = new streamType[0]
                }
            };
        }

        public static bone_visibility_animType CreateEmptyBoneVisibilityAnim()
        {
            return new bone_visibility_animType()
            {
                bone_visibility_anim_info = new bone_visibility_anim_infoType()
                {
                },
                bone_vis_bone_anim_array = new bone_vis_bone_anim_arrayType()
                {
                    bone_vis_bone_anim = new bone_vis_bone_animType[0]
                },
                stream_array = new stream_arrayType()
                {
                    stream = new streamType[0]
                }
            };
        }

        public static bone_animType AddBoneAnim(
            this skeletal_animType target,
            string name, string parent)
        {
            return AddBoneAnim(target, name, parent, -1, -1);
        }

        public static bone_animType AddBoneAnim(
            this skeletal_animType target,
            string name, string parent, int smoothSkinningMatrixIndex, int rigidSkinningMatrixIndex)
        {
            List<bone_animType> newBones = new List<bone_animType>(target.bone_anim_array.bone_anim);
            bone_animType bone = new bone_animType()
            {
                name = name,
                parent_name = parent,
                matrix_index = new int[] { smoothSkinningMatrixIndex, rigidSkinningMatrixIndex },
                compress_enable = true,
            };
            newBones.Add(bone);

            target.bone_anim_array.bone_anim = newBones.ToArray();
            target.bone_anim_array.length = target.bone_anim_array.bone_anim.Length;
            return bone;
        }

        public static bone_vis_bone_animType AddBoneVisibilityAnim(
            this bone_visibility_animType target,
            string name, string parent)
        {
            return AddBoneVisibilityAnim(target, name, parent, -1, -1);
        }

        public static bone_vis_bone_animType AddBoneVisibilityAnim(
            this bone_visibility_animType target,
            string name, string parent, int smoothSkinningMatrixIndex, int rigidSkinningMatrixIndex)
        {
            List<bone_vis_bone_animType> newBones = new List<bone_vis_bone_animType>(target.bone_vis_bone_anim_array.bone_vis_bone_anim);
            bone_vis_bone_animType bone = new bone_vis_bone_animType()
            {
                name = name,
                parent_name = parent,
                matrix_index = new int[] { smoothSkinningMatrixIndex, rigidSkinningMatrixIndex },
                compress_enable = true,
            };
            newBones.Add(bone);

            target.bone_vis_bone_anim_array.bone_vis_bone_anim = newBones.ToArray();
            target.bone_vis_bone_anim_array.length = target.bone_vis_bone_anim_array.bone_vis_bone_anim.Length;
            return bone;
        }
    }
}
