﻿// デバッグビルド時にコメントアウトを外すと、インテリセンスが効くようになります。編集するときにコメントアウトを外します。
//#r "..\..\..\..\..\..\Outputs\AnyCPU\Tools\3dToolsTest\3dIntermediateFileTextureCompositorTest\Debug\Nintendo.ToolFoundation.dll"
//#r "..\..\..\..\..\..\Outputs\AnyCPU\Tools\3dToolsTest\3dIntermediateFileTextureCompositorTest\Debug\Opal.dll"
//#r "..\..\..\..\..\..\Outputs\AnyCPU\Tools\3dToolsTest\3dIntermediateFileTextureCompositorTest\Debug\Nintendo.G3dTool.dll"

using Nintendo.G3dTool.Entities;
using TextureCompositor;
using System;
using System.Linq;
using System.Diagnostics;

// マテリアル事前処理スクリプト
public static void PreprocessMaterial(PreprocessMaterialArg arg)
{
    Material material = arg.Material;
    ShaderDefinition shaderDef = arg.ShaderDefinition;
    System.Console.WriteLine($"Material Name: {material.Name}");

    // enable_mix_tex をサンプラーの有無によって自動設定
    {
        var option = material.ShaderAssign.ShaderOptions.FirstOrDefault(x => x.Id == "enable_mix_tex");
        if (option == null)
        {
            material.ShaderAssign.ShaderOptions.Add(new ShaderOption() { Id = "enable_mix_tex" });
        }

        var specularSamplerAssign = material.ShaderAssign.SamplerAssigns.FirstOrDefault(x => x.SamplerName == "_s0");
        bool isSpeculerAssigned = specularSamplerAssign != null && !string.IsNullOrEmpty(specularSamplerAssign.SamplerName);

        var aoSamplerAssign = material.ShaderAssign.SamplerAssigns.FirstOrDefault(x => x.SamplerName == "_x0");
        bool isAoAssigned = aoSamplerAssign != null && !string.IsNullOrEmpty(aoSamplerAssign.SamplerName);
        if (isSpeculerAssigned && isAoAssigned)
        {
            option.Value = "1";
        }
        else
        {
            option.Value = "0";
        }
    }
}

// テクスチャー変換スクリプト
public static void ConvertTexture(ConvertTextureArg arg)
{
    // ツールから渡されたオプションでそのままテクスチャーコンバーターを実行
    ExecuteProcess(arg.TextureConverterPath, arg.TextureConverterOptions.ToString());
}

private static void ExecuteProcess(string cmd, string args)
{
    var info = new ProcessStartInfo(cmd, args) { UseShellExecute = false };
    info.RedirectStandardError = true;
    info.RedirectStandardOutput = true;
    info.CreateNoWindow = true;

    var process = new Process { StartInfo = info };
    process.OutputDataReceived += (s, e) =>
    {
        if (e.Data != null)
        {
            Console.WriteLine(e.Data);
        }
    };

    process.ErrorDataReceived += (s, e) =>
    {
        if (e.Data != null)
        {
            Console.Error.WriteLine(e.Data);
        }
    };

    process.Start();
    process.BeginOutputReadLine();
    process.BeginErrorReadLine();
    process.WaitForExit();
}
