﻿using System;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using _3dToolsTestUtility;

namespace g3diflib_tests.Merge
{
    [TestClass]
    public partial class ModelMergerTests
    {
        public void TestMergeSampler(
            string nameArg,
            string hintArg,
            string nameMerge,
            string hintMerge,
            char expect)
        {
            var arg = new sampler_arrayType
            {
                length = 1,
                sampler = new samplerType[]
                {
                    new samplerType
                    {
                        name = nameArg,
                        hint = hintArg,
                        tex_name = "tex0",
                        wrap = new wrapType
                        {
                            u = wrap_uvwType.mirror,
                            v = wrap_uvwType.mirror_once,
                            w = wrap_uvwType.repeat
                        },
                        filter = new filterType
                        {
                            mag = filter_mag_minType.linear,
                            max_aniso = filter_max_anisoType.aniso_1,
                            min = filter_mag_minType.point,
                            mip = filter_mipType.none
                        },
                        lod = new lodType {
                            bias = 3,
                            max = 2,
                            min = 1,
                        },
                    }
                }
            };
            var merge = new sampler_arrayType
            {
                length = 1,
                sampler = new samplerType[]
                {
                    new samplerType
                    {
                        name = nameMerge,
                        hint = hintMerge,
                        tex_name = "tex1",
                        wrap = new wrapType
                        {
                            u = wrap_uvwType.clamp,
                            v = wrap_uvwType.mirror,
                            w = wrap_uvwType.mirror_once
                        },
                        filter = new filterType
                        {
                            mag = filter_mag_minType.point,
                            max_aniso = filter_max_anisoType.aniso_2,
                            min = filter_mag_minType.linear,
                            mip = filter_mipType.point
                        },
                        lod = new lodType {
                            bias = 6,
                            max = 5,
                            min = 4,
                        },
                    }
                }
            };
            var merger = new PrivateType(typeof(IfModelMerger));
            var result = (List<samplerType>)merger.InvokeStatic("MergeSampler", arg, merge);
            switch (expect)
            {
                case 'o': // 無視
                    Assert.IsTrue(result.Count == 1);
                    SamplersAreEqual(arg.Items[0], result[0]);
                    break;
                case 'a': // 追加
                    Assert.IsTrue(result.Count == 2);
                    SamplersAreEqual(arg.Items[0], result[0]);
                    SamplersAreEqual(merge.Items[0], result[1]);
                    break;
                case 'm': // パラメータのマージ
                    Assert.IsTrue(result.Count == 1);
                    Assert.AreEqual(arg.Items[0].name, result[0].name);
                    Assert.AreEqual(arg.Items[0].hint, result[0].hint);
                    Assert.AreEqual(arg.Items[0].tex_name, result[0].tex_name);
                    Assert.IsTrue(CompareUtility.AreEqualAsXml(arg.Items[0].wrap.u, result[0].wrap.u));
                    Assert.IsTrue(CompareUtility.AreEqualAsXml(arg.Items[0].wrap.v, result[0].wrap.v));
                    Assert.IsTrue(CompareUtility.AreEqualAsXml(merge.Items[0].wrap.w, result[0].wrap.w));
                    Assert.IsTrue(CompareUtility.AreEqualAsXml(merge.Items[0].filter, result[0].filter));
                    Assert.IsTrue(CompareUtility.AreEqualAsXml(merge.Items[0].lod, result[0].lod));
                    break;
            }
        }

        private void SamplersAreEqual(samplerType lhs, samplerType rhs)
        {
            // index は比較しない
            Assert.AreEqual(lhs.name, rhs.name);
            Assert.AreEqual(lhs.hint, rhs.hint);
            Assert.AreEqual(lhs.tex_name, rhs.tex_name);
            Assert.IsTrue(CompareUtility.AreEqualAsXml(lhs.wrap, rhs.wrap));
            Assert.IsTrue(CompareUtility.AreEqualAsXml(lhs.filter, rhs.filter));
            Assert.IsTrue(CompareUtility.AreEqualAsXml(lhs.lod, rhs.lod));
        }

        // ModelMergerTestT4.cs が空でないことの確認用のダミー
        private void Dummy()
        {
            ModelMergerTestT4Dummy();
        }

        /// <summary>
        /// ボーンマージのテストです。
        /// </summary>
        [TestMethod]
        public void TestMergeBone()
        {
            boneType newBone = new boneType()
            {
                visibility = true
            };
            boneType oldBone = new boneType()
            {
                visibility = false
            };

            IfModelMerger.IfModelMergerInfo info = new IfModelMerger.IfModelMergerInfo();
            info.BoneVisibilityMergePriorityToNewModel = true;
            IfModelMerger.MergeBone(newBone, null, oldBone, null, info);
            Assert.IsTrue(newBone.visibility);

            info.BoneVisibilityMergePriorityToNewModel = false;
            IfModelMerger.MergeBone(newBone, null, oldBone, null, info);
            Assert.IsFalse(newBone.visibility);
        }
    }
}
