﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.Reflection;
using _3dToolsTestUtility;

namespace _3dIntermediateFileFilterTest
{
    [TestClass]
    public class FilterSampleTest
    {
        public FilterSampleTest()
        {
            IoUtility.WriteLogLine($"{this.GetType().Name}");
        }

        /// <summary>
        /// 中間ファイルフィルターのサンプルを実行して成功するかを確認するテストです。
        /// </summary>
        [TestMethod]
        public void TestExecuteFilterSample()
        {
            IoUtility.WriteLogLine($"{MethodBase.GetCurrentMethod().Name}");
            string assemblyFolder = System.IO.Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            string sdkRoot = IoUtility.GetSdkRootPath();
            string filterSampleFolder = System.IO.Path.Combine(sdkRoot, "Samples/Sources/Tools/3dTools/3dIntermediateFileFilter");
            string resourceFolder = System.IO.Path.Combine(assemblyFolder, "Resources");
            var sampleBatPaths = System.IO.Directory.EnumerateFiles(filterSampleFolder, "*.bat", System.IO.SearchOption.AllDirectories);

            try
            {
                foreach (string sampleBatPath in sampleBatPaths)
                {
                    IoUtility.WriteLogLine($"Testing {sampleBatPath}");
                    Assert.IsTrue(System.IO.File.Exists(sampleBatPath), $"{sampleBatPath} was not found.");
                    ProcessExecutor.Execute(sampleBatPath, resourceFolder);
                }
            }
            finally
            {
                // 中間ファイルフィルターサンプルによって作られた生成物を削除
                List<string> deleteFiles = new List<string>();
                deleteFiles.AddRange(System.IO.Directory.EnumerateFiles(filterSampleFolder, "*.txt", System.IO.SearchOption.AllDirectories));
                deleteFiles.AddRange(System.IO.Directory.EnumerateFiles(filterSampleFolder, "*.csv", System.IO.SearchOption.AllDirectories));
                foreach (var deleteFile in deleteFiles)
                {
                    IoUtility.WriteLogLine($"Deleting {deleteFile}");
                    System.IO.File.Delete(deleteFile);
                }
            }
        }
    }
}
