﻿using _3dToolsTestUtility;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace _3dIntermediateFileConverterTest
{
    public static class Utility
    {
        public delegate void TestProcessDelegate(string outputFilePath);

        public static void TestForAllModelFiles(string fileFilter, string additionalArgs, TestProcessDelegate testProcess)
        {
            G3dParallel.Job = 1;
            string assemblyFolder = System.IO.Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            string resourceFolder = System.IO.Path.Combine(assemblyFolder, "Resources");
            var inputFiles = System.IO.Directory.EnumerateFiles(resourceFolder, fileFilter, System.IO.SearchOption.AllDirectories);
            foreach (string inputFile in inputFiles)
            {
                string tempFolder = IoUtility.GetTempFolderPath();
                System.IO.Directory.CreateDirectory(tempFolder);
                try
                {
                    nw.g3d.ifcvtr.g3difcvtr g3difcvtr = new nw.g3d.ifcvtr.g3difcvtr();
                    string outputFmdFilePath = System.IO.Path.Combine(
                        tempFolder,
                        $"{System.IO.Path.GetFileNameWithoutExtension(inputFile)}.fmdb");

                    g3difcvtr.Arguments = $"{inputFile} -o {outputFmdFilePath} -j 1 --gpu-encoding false {additionalArgs}";
                    g3difcvtr.XsdBasePath = IoUtility.GetXsdBasePath();
                    g3difcvtr.G3dToolRoot = IoUtility.Get3dToolsRootPath();

                    IoUtility.WriteLogLine($"Argument: {g3difcvtr.Arguments}");
                    g3difcvtr.Run();

                    testProcess(outputFmdFilePath);
                }
                catch (Exception exception)
                {
                    IoUtility.WriteErrorLine($"{exception.Message}\n{exception.StackTrace}");

                    // ツール内で書き出されたログが潰されるかもしれないので一応フラッシュしておく
                    Console.Out.Flush();
                    throw;
                }
                finally
                {
                    if (System.IO.Directory.Exists(tempFolder))
                    {
                        System.IO.Directory.Delete(tempFolder, true);
                    }
                }
            }
        }
    }
}
