﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.Reflection;
using nw.g3d.toollib;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using _3dToolsTestUtility;
using Nintendo.G3dTool.Entities;
using System.IO;

namespace _3dIntermediateFileConverterTest
{
    [TestClass]
    public class ConvertObjTest
    {
        public ConvertObjTest()
        {
            IoUtility.WriteLogLine($"{this.GetType().Name}");
        }

        /// <summary>
        /// 中間ファイルコンバーターの .obj 変換テストです。
        /// </summary>
        [TestMethod]
        public void TestObjConversion()
        {
            IoUtility.WriteLogLine($"{MethodBase.GetCurrentMethod().Name}");
            Utility.TestForAllModelFiles("*.obj", string.Empty, outputFmdFilePath =>
            {
                // 出力後の fmdb が読み込めるかをテスト
                var file = IfReadUtility.ReadIntermediateFile(outputFmdFilePath, IoUtility.GetXsdBasePath());
                var model = file.GetRootEntity<Model>();
                Assert.IsNotNull(model);

                // テクスチャーが作られているか
                string outputFolder = System.IO.Path.GetDirectoryName(outputFmdFilePath);
                string texFolderPath = System.IO.Path.Combine(outputFolder, "textures");
                Assert.IsTrue(System.IO.Directory.Exists(texFolderPath));
            });
        }

        [TestMethod]
        public void TestObjDisableTexture()
        {
            IoUtility.WriteLogLine($"{MethodBase.GetCurrentMethod().Name}");
            Utility.TestForAllModelFiles("*.obj", "--disable-texture", outputFmdFilePath =>
            {
                // 出力後にテクスチャーが書き出されていないことをテスト
                string outputFolder = System.IO.Path.GetDirectoryName(outputFmdFilePath);
                string texFolderPath = System.IO.Path.Combine(outputFolder, "textures");
                Assert.IsFalse(System.IO.Directory.Exists(texFolderPath));
            });
        }

        [TestMethod]
        public void TestObjDisableOriginalImage()
        {
            IoUtility.WriteLogLine($"{MethodBase.GetCurrentMethod().Name}");
            Utility.TestForAllModelFiles("*.obj", "--disable-original-image", outputFmdFilePath =>
            {
                // 出力テクスチャーにオリジナルイメージが書き出されていないことをテスト
                string outputFolder = System.IO.Path.GetDirectoryName(outputFmdFilePath);
                string texFolderPath = System.IO.Path.Combine(outputFolder, "textures");
                Assert.IsTrue(System.IO.Directory.Exists(texFolderPath));
                var outputTextures = Directory.EnumerateFiles(texFolderPath, "*.ftxb");
                Assert.IsTrue(outputTextures.Count() > 0);
                foreach (var texPath in outputTextures)
                {
                    var texFile = IfReadUtility.ReadIntermediateFile(texPath, IoUtility.GetXsdBasePath());
                    var tex = texFile.GetRootEntity<Texture>();
                    Assert.AreEqual(0, tex.OriginalImages.Count);
                }
            });
        }
    }
}
