﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.nw4f_3dif;

namespace G3dLibraryTest
{
    [TestClass]
    public class StreamTest
    {
        [TestMethod]
        public void StreamFloatTest()
        {
            streamType source = new streamType();
            source.column = 3;
            source.count = 6;
            source.type = stream_typeType.@float;
            source.Value = "0.0 1.0 2.0\n3.0 4.0 5.0";
            StreamFloat stream = new StreamFloat(source);
            float[] CorrectData = { 0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
            for (int i = 0; i < CorrectData.Length; ++i)
            {
                Assert.AreEqual(CorrectData[i], stream.Values[i]);
            }

            Assert.AreEqual(false, stream.IsDirty);

            stream.AutoCalc = true;
            stream.Values.Add(6.0f);
            stream.Values.Add(7.0f);
            stream.Values.Add(8.0f);

            Assert.AreEqual(true, stream.IsDirty);

            var writeData = stream.CreateSerializableData();
            Assert.IsTrue(writeData.Value.Contains("6"));
            Assert.IsTrue(writeData.Value.Contains("7"));
            Assert.IsTrue(writeData.Value.Contains("8"));
        }
    }
}
